/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CCTask;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.StringUtils;

public class CUtil {
    public static final int FILETIME_EPSILON = 500;

    public static void addAll(Vector dest, Object[] src) {
        if (src == null) {
            return;
        }
        for (int i = 0; i < src.length; ++i) {
            dest.addElement(src[i]);
        }
    }

    public static int checkDirectoryArray(String[] names) {
        int count = 0;
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            File dir = new File(names[i]);
            if (dir.exists() && dir.isDirectory()) {
                ++count;
                continue;
            }
            names[i] = null;
        }
        return count;
    }

    public static String getBasename(File file) {
        String path = file.getPath();
        String basename = file.getName();
        int pos = basename.lastIndexOf(46);
        if (pos != -1) {
            basename = basename.substring(0, pos);
        }
        return basename;
    }

    public static File getExecutableLocation(String exeName) {
        File currentDir = new File(System.getProperty("user.dir"));
        if (new File(currentDir, exeName).exists()) {
            return currentDir;
        }
        File[] envPath = CUtil.getPathFromEnvironment("PATH", File.pathSeparator);
        for (int i = 0; i < envPath.length; ++i) {
            if (!new File(envPath[i], exeName).exists()) continue;
            return envPath[i];
        }
        return null;
    }

    public static String getParentPath(String path) {
        int pos = path.lastIndexOf(File.separator);
        if (pos <= 0) {
            return null;
        }
        return path.substring(0, pos);
    }

    public static File[] getPathFromEnvironment(String envVariable, String delim) {
        if (System.getProperty("os.name").equals("OS/400")) {
            return new File[0];
        }
        Vector osEnv = Execute.getProcEnvironment();
        String match = envVariable.concat("=");
        Enumeration e = osEnv.elements();
        while (e.hasMoreElements()) {
            String entryFrag;
            String entry = ((String)e.nextElement()).trim();
            if (entry.length() <= match.length() || !(entryFrag = entry.substring(0, match.length())).equalsIgnoreCase(match)) continue;
            String path = entry.substring(match.length());
            return CUtil.parsePath(path, delim);
        }
        File[] noPath = new File[]{};
        return noPath;
    }

    public static String getRelativePath(String base, File targetFile) {
        try {
            String prefix2;
            int endPrefix;
            String prefix1;
            String canonicalTarget;
            String canonicalBase = base;
            if (base.charAt(base.length() - 1) != File.separatorChar) {
                canonicalBase = base + File.separatorChar;
            }
            if (canonicalBase.startsWith((canonicalTarget = System.getProperty("os.name").equals("OS/400") ? targetFile.getPath() : targetFile.getCanonicalPath()) + File.separatorChar)) {
                canonicalTarget = canonicalTarget + File.separator;
            }
            if (canonicalTarget.equals(canonicalBase)) {
                return ".";
            }
            if (canonicalBase.substring(0, 2).equals("\\\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = canonicalBase.indexOf(92, 2))).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : (canonicalBase.substring(1, 3).equals(":\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = 2)).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : canonicalBase.charAt(0) == '/' && canonicalTarget.charAt(0) != '/')) {
                return canonicalTarget;
            }
            char separator = File.separatorChar;
            int lastCommonSeparator = -1;
            int minLength = canonicalBase.length();
            if (canonicalTarget.length() < minLength) {
                minLength = canonicalTarget.length();
            }
            for (int i = 0; i < minLength && canonicalTarget.charAt(i) == canonicalBase.charAt(i); ++i) {
                if (canonicalTarget.charAt(i) != separator) continue;
                lastCommonSeparator = i;
            }
            StringBuffer relativePath = new StringBuffer(50);
            for (int i = lastCommonSeparator + 1; i < canonicalBase.length(); ++i) {
                if (canonicalBase.charAt(i) != separator) continue;
                if (relativePath.length() > 0) {
                    relativePath.append(separator);
                }
                relativePath.append("..");
            }
            if (canonicalTarget.length() > lastCommonSeparator + 1) {
                if (relativePath.length() > 0) {
                    relativePath.append(separator);
                }
                relativePath.append(canonicalTarget.substring(lastCommonSeparator + 1));
            }
            return relativePath.toString();
        }
        catch (IOException iOException) {
            return targetFile.toString();
        }
    }

    public static boolean isActive(Project p, String ifCond, String unlessCond) throws BuildException {
        String unlessValue;
        if (ifCond != null) {
            String ifValue = p.getProperty(ifCond);
            if (ifValue == null) {
                return false;
            }
            if (ifValue.equals("false") || ifValue.equals("no")) {
                throw new BuildException("if condition \"" + ifCond + "\" has suspicious value \"" + ifValue);
            }
        }
        if (unlessCond != null && (unlessValue = p.getProperty(unlessCond)) != null) {
            if (unlessValue.equals("false") || unlessValue.equals("no")) {
                throw new BuildException("unless condition \"" + unlessCond + "\" has suspicious value \"" + unlessValue);
            }
            return false;
        }
        return true;
    }

    public static File[] parsePath(String path, String delim) {
        Vector<File> libpaths = new Vector<File>();
        int delimPos = 0;
        int startPos = 0;
        while (startPos < path.length()) {
            String dirName;
            File dir;
            delimPos = path.indexOf(delim, startPos);
            if (delimPos < 0) {
                delimPos = path.length();
            }
            if (delimPos > startPos && (dir = new File(dirName = path.substring(startPos, delimPos))).exists() && dir.isDirectory()) {
                libpaths.addElement(dir);
            }
            startPos = delimPos + delim.length();
        }
        Object[] paths = new File[libpaths.size()];
        libpaths.copyInto(paths);
        return paths;
    }

    public static int runCommand(CCTask task, File workingDir, String[] cmdline, boolean newEnvironment, Environment env) throws BuildException {
        try {
            task.log(Commandline.toString((String[])cmdline), task.getCommandLogLevel());
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)task, 2, 0));
            if (System.getProperty("os.name").equals("OS/390")) {
                exe.setVMLauncher(false);
            }
            exe.setAntRun(task.getProject());
            exe.setCommandline(cmdline);
            exe.setWorkingDirectory(workingDir);
            if (env != null) {
                String[] environment = env.getVariables();
                if (environment != null) {
                    for (int i = 0; i < environment.length; ++i) {
                        task.log("Setting environment variable: " + environment[i], 3);
                    }
                }
                exe.setEnvironment(environment);
            }
            exe.setNewenvironment(newEnvironment);
            return exe.execute();
        }
        catch (IOException exc) {
            throw new BuildException("Could not launch " + cmdline[0] + ": " + exc, task.getLocation());
        }
    }

    public static boolean sameList(Object[] a, Object[] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean sameList(Vector v, Object[] a) {
        if (v == null || a == null || v.size() != a.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            Object o = a[i];
            if (o.equals(v.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean sameSet(Object[] a, Vector b) {
        int i;
        if (a == null || b == null || a.length != b.size()) {
            return false;
        }
        if (a.length == 0) {
            return true;
        }
        Hashtable<Object, Object> t = new Hashtable<Object, Object>();
        for (i = 0; i < a.length; ++i) {
            t.put(a[i], a[i]);
        }
        for (i = 0; i < b.size(); ++i) {
            Object o = b.elementAt(i);
            if (t.remove(o) != null) continue;
            return false;
        }
        return t.size() == 0;
    }

    public static String[] toArray(Vector src) {
        Object[] retval = new String[src.size()];
        src.copyInto(retval);
        return retval;
    }

    public static String xmlAttribEncode(String attrValue) {
        StringBuffer buf = new StringBuffer(attrValue);
        int quotePos = -1;
        while ((quotePos = buf.indexOf("\"", quotePos + 1)) >= 0) {
            buf.deleteCharAt(quotePos);
            buf.insert(quotePos, "&quot;");
            quotePos += 5;
        }
        quotePos = -1;
        while ((quotePos = buf.indexOf("<", quotePos + 1)) >= 0) {
            buf.deleteCharAt(quotePos);
            buf.insert(quotePos, "&lt;");
            quotePos += 3;
        }
        quotePos = -1;
        while ((quotePos = buf.indexOf(">", quotePos + 1)) >= 0) {
            buf.deleteCharAt(quotePos);
            buf.insert(quotePos, "&gt;");
            quotePos += 3;
        }
        return buf.toString();
    }

    public static boolean isSignificantlyBefore(long time1, long time2) {
        return time1 + 500L < time2;
    }

    public static boolean isSignificantlyAfter(long time1, long time2) {
        return time1 > time2 + 500L;
    }

    public static String toWindowsPath(String path) {
        if (File.separatorChar != '\\' && path.indexOf(File.separatorChar) != -1) {
            return StringUtils.replace((String)path, (String)File.separator, (String)"\\");
        }
        return path;
    }

    public static String toUnixPath(String path) {
        if (File.separatorChar != '/' && path.indexOf(File.separatorChar) != -1) {
            return StringUtils.replace((String)path, (String)File.separator, (String)"/");
        }
        return path;
    }

    public static boolean isSystemPath(File source) {
        String lcPath = source.getAbsolutePath().toLowerCase(Locale.US);
        return lcPath.indexOf("platformsdk") != -1 || lcPath.indexOf("microsoft") != -1 || lcPath == "/usr/include" || lcPath == "/usr/lib" || lcPath == "/usr/local/include" || lcPath == "/usr/local/lib";
    }

    public static final class StringArrayBuilder {
        private String[] _value;

        public StringArrayBuilder(String value) {
            StringTokenizer tokens = new StringTokenizer(value, ", ");
            Vector<String> vallist = new Vector<String>();
            while (tokens.hasMoreTokens()) {
                String val = tokens.nextToken().trim();
                if (val.length() == 0) continue;
                vallist.addElement(val);
            }
            this._value = new String[vallist.size()];
            vallist.copyInto(this._value);
        }

        public String[] getValue() {
            return this._value;
        }
    }
}

