package com.github.markzhai.uiframework.helper;

import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup.LayoutParams;

import com.github.markzhai.uikit.R;
import com.github.markzhai.uikit.StateView;
import com.github.markzhai.uikit.StateView.OnConfigStateViewListener;
import com.github.markzhai.uikit.StateView.State;

/**
 * @author markzhai on 16/2/28
 * @version 1.0.0
 */
public class StateViewHelper {
    private OnConfigStateViewListener mDefaultConfig = new OnConfigStateViewListener() {
        public void onConfigStateView(View view, State state) {
            if (State.FAILED.equals(state)) {
                view.setOnClickListener(StateViewHelper.this.mOnRetryClickListener);
            }
        }
    };
    private OnClickListener mOnRetryClickListener;

    public StateView inject(View view, OnClickListener onRetryClickListener) {
        this.mOnRetryClickListener = onRetryClickListener;
        StateView stateView = new StateView(view.getContext());
        stateView.setStateProperty(State.FAILED, R.layout.loadingview_failed);
        stateView.setStateProperty(State.LOADING, R.layout.loadingview_loading);
        stateView.setStateProperty(State.NO_DATA, R.layout.loadingview_nodata);
        stateView.setStateProperty(State.SUCCESS, view);
        stateView.setOnConfigStateViewListener(this.mDefaultConfig);
        stateView.setLayoutParams(new LayoutParams(-1, -1));
        return stateView;
    }
}