/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.mixins;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ResponseRenderer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.TextStreamResponse;
import org.got5.tapestry5.jquery.ImportJQueryUI;

@ImportJQueryUI(value={"jquery.ui.widget", "jquery.ui.position", "jquery.ui.autocomplete"})
@Import(library={"${assets.path}/mixins/autocomplete/autocomplete.js"})
public class Autocomplete {
    static final String EVENT_NAME = "autocomplete";
    private static final String PARAM_NAME = "t:input";
    private static final String EXTRA_NAME = "extra";
    @InjectContainer
    private Field field;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private Request request;
    @Parameter(defaultPrefix="literal")
    private int minChars;
    @Inject
    private ResponseRenderer responseRenderer;
    @Parameter(defaultPrefix="literal")
    private double frequency;
    @Parameter(defaultPrefix="literal")
    private String tokens;
    @Parameter(defaultPrefix="literal")
    private JSONObject options;

    void afterRender(MarkupWriter writer) {
        String id = this.field.getClientId();
        Link link = this.resources.createEventLink(EVENT_NAME, new Object[0]);
        JSONObject config = new JSONObject();
        config.put("id", (Object)id);
        config.put("url", (Object)link.toAbsoluteURI());
        config.put("paramName", (Object)PARAM_NAME);
        if (this.resources.isBound("minChars")) {
            config.put("minLength", (Object)this.minChars);
        }
        if (this.resources.isBound("frequency")) {
            config.put("delay", (Object)this.frequency);
        }
        if (this.resources.isBound("tokens")) {
            for (int i = 0; i < this.tokens.length(); ++i) {
                config.accumulate("tokens", (Object)this.tokens.substring(i, i + 1));
            }
        }
        config.put("options", (Object)this.options);
        this.configure(config);
        this.javaScriptSupport.addInitializerCall(EVENT_NAME, config);
    }

    Object onAutocomplete() {
        Object[] objectArray;
        JSONObject json = new JSONObject(this.request.getParameter("data"));
        JSONObject extra = json.length() > 1 ? new JSONObject(json.getString(EXTRA_NAME)) : new JSONObject();
        String input = json.getString(PARAM_NAME);
        final Holder matchesHolder = Holder.create();
        matchesHolder.put(Collections.emptyList());
        ComponentEventCallback<List> callback = new ComponentEventCallback<List>(){

            public boolean handleResult(List result) {
                matchesHolder.put((Object)result);
                return true;
            }
        };
        if (extra.length() == 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = input;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = input;
            objectArray = objectArray3;
            objectArray3[1] = extra;
        }
        Object[] params = objectArray;
        this.resources.triggerEvent("provideCompletions", params, (ComponentEventCallback)callback);
        ContentType contentType = this.responseRenderer.findContentType((Object)this);
        return new TextStreamResponse(contentType.toString(), this.generateResponseJSON((List)matchesHolder.get()).toString());
    }

    protected void configure(JSONObject config) {
    }

    protected JSONArray generateResponseJSON(List matches) {
        JSONArray array = new JSONArray();
        for (Object o : matches) {
            if (o instanceof JSONObject) {
                array.put(o);
                continue;
            }
            array.put((Object)o.toString());
        }
        return array;
    }
}

