/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ClientBehaviorSupport;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class CarouselItem
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Property
    @Parameter(value="75", defaultPrefix="literal")
    private int width;
    @Property
    @Parameter(value="75", defaultPrefix="literal")
    private int height;
    @Property
    @Parameter(required=true, defaultPrefix="prop")
    private String imageSource;
    @Property
    @Parameter(defaultPrefix="literal")
    private String page;
    @Property
    @Parameter(defaultPrefix="literal")
    private String event;
    @Property
    @Parameter(allowNull=true, defaultPrefix="prop")
    private Object context;
    @Property
    @Parameter(defaultPrefix="literal")
    private String zone;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ClientBehaviorSupport clientSupport;
    @Inject
    private PageRenderLinkSource pageRenderLink;

    public boolean isPagelink() {
        return StringUtils.isNotEmpty((String)this.page);
    }

    public boolean isEventlink() {
        return StringUtils.isNotEmpty((String)this.event);
    }

    @SetupRender
    public boolean init(MarkupWriter w) {
        w.element("li", new Object[0]);
        if (this.isPagelink()) {
            Link url = null;
            url = this.context != null ? this.pageRenderLink.createPageRenderLinkWithContext(this.page, new Object[]{this.context}) : this.pageRenderLink.createPageRenderLinkWithContext(this.page, new Object[0]);
            w.element("a", new Object[]{"href", url.toURI()});
        } else if (this.isEventlink()) {
            String linkId = this.javaScriptSupport.allocateClientId(this.componentResources);
            Link url = null;
            url = this.context != null ? this.componentResources.createEventLink(this.event, new Object[]{this.context}) : this.componentResources.createEventLink(this.event, new Object[0]);
            w.element("a", new Object[]{"href", url.toURI(), "id", linkId});
            if (this.zone != null) {
                this.clientSupport.linkZone(linkId, this.zone, url);
            }
        }
        w.element("img", new Object[]{"src", this.imageSource, "height", this.height + "px", "width", this.width + "px"});
        this.componentResources.renderInformalParameters(w);
        w.end();
        if (this.isPagelink() || this.isEventlink()) {
            w.end();
        }
        w.end();
        return false;
    }

    public String getClientId() {
        return this.clientId;
    }
}

