/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.math.MathEx;
import smile.tensor.AbstractTensor;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

class Vector32
extends Vector {
    final float[] array;
    final int offset;
    final int length;

    private Vector32() {
        this.array = null;
        this.offset = 0;
        this.length = 0;
    }

    private Vector32(MemorySegment memory, float[] array, int offset, int length, int m, int n) {
        if (offset < 0 || offset >= array.length) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (offset + length > array.length) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (m != 1 && n != 1) {
            throw new IllegalArgumentException("Invalid vector dimension: " + m + " x " + n);
        }
        if (m != length && n != length) {
            throw new IllegalArgumentException("Invalid vector dimension: " + m + " x " + n);
        }
        super(memory, m, n);
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public static Vector32 column(float[] array, int offset, int length) {
        return new Vector32(Vector32.memory(array, offset, length), array, offset, length, length, 1);
    }

    public static Vector32 row(float[] array, int offset, int length) {
        return new Vector32(Vector32.memory(array, offset, length), array, offset, length, 1, length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memory = Vector32.memory(this.array, this.offset, this.length);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Vector32) {
            Vector32 b = (Vector32)other;
            if (this.length == b.length) {
                for (int i = 0; i < this.length; ++i) {
                    if (!(Math.abs(this.array[this.offset + i] - b.array[b.offset + i]) > MathEx.FLOAT_EPSILON)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String suffix = this.size() > 10 ? ", ...]" : "]";
        return IntStream.range(0, this.length).limit(10L).mapToObj(i -> AbstractTensor.format(this.array[this.offset + i])).collect(Collectors.joining(", ", "[", suffix));
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float32;
    }

    @Override
    public Vector32 transpose() {
        return new Vector32(this.memory, this.array, this.offset, this.length, this.n, this.m);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public double get(int i, int j) {
        assert (i == 0 || j == 0);
        return this.array[this.offset + i + j];
    }

    @Override
    public void set(int i, int j, double x) {
        assert (i == 0 || j == 0);
        this.array[this.offset + i + j] = (float)x;
    }

    @Override
    public void add(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] + (float)x;
    }

    @Override
    public void sub(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] - (float)x;
    }

    @Override
    public void mul(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] * (float)x;
    }

    @Override
    public void div(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] / (float)x;
    }

    @Override
    public double get(int i) {
        return this.array[this.offset + i];
    }

    @Override
    public void set(int i, double x) {
        this.array[this.offset + i] = (float)x;
    }

    @Override
    public void add(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] + (float)x;
    }

    @Override
    public void sub(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] - (float)x;
    }

    @Override
    public void mul(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] * (float)x;
    }

    @Override
    public void div(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] / (float)x;
    }

    @Override
    public Vector slice(int from, int to) {
        int length = to - from;
        long byteSize = this.scalarType().byteSize();
        MemorySegment slice = this.memory.asSlice((long)from * byteSize, (long)length * byteSize);
        int m = this.nrow() > 1 ? length : 1;
        int n = this.nrow() > 1 ? 1 : length;
        return new Vector32(slice, this.array, this.offset + from, length, m, n);
    }

    @Override
    public Vector copy(int from, int to) {
        float[] data = Arrays.copyOfRange(this.array, this.offset + from, this.offset + to);
        int length = data.length;
        return this.nrow() > 1 ? Vector32.column(data, 0, length) : Vector32.row(data, 0, length);
    }

    @Override
    public double[] toArray(double[] a) {
        if (a.length < this.length) {
            a = new double[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            a[i] = this.array[this.offset + i];
        }
        return a;
    }

    @Override
    public float[] toArray(float[] a) {
        if (a.length < this.length) {
            a = Arrays.copyOfRange(this.array, this.offset, this.offset + this.length);
        } else {
            System.arraycopy(this.array, this.offset, a, 0, this.length);
        }
        return a;
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.array, this.offset, this.offset + this.length, (float)value);
    }

    @Override
    public void fill(int from, int to, double value) {
        Arrays.fill(this.array, this.offset + from, this.offset + to, (float)value);
    }

    @Override
    public int softmax() {
        int i;
        int k = this.length;
        int y = -1;
        float max = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < k; ++i2) {
            if (!(this.array[this.offset + i2] > max)) continue;
            max = this.array[this.offset + i2];
            y = i2;
        }
        float Z = 0.0f;
        for (i = 0; i < k; ++i) {
            float out;
            this.array[this.offset + i] = out = (float)Math.exp(this.array[this.offset + i] - max);
            Z += out;
        }
        for (i = 0; i < k; ++i) {
            int n = this.offset + i;
            this.array[n] = this.array[n] / Z;
        }
        return y;
    }
}

