/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import smile.linalg.blas.cblas_h;
import smile.tensor.DenseMatrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector32;
import smile.tensor.Vector64;

public abstract class Vector
extends DenseMatrix {
    Vector() {
    }

    Vector(MemorySegment memory, int m, int n) {
        super(memory, m, n, m, null, null);
        assert (m == 1 || n == 1);
    }

    public abstract int size();

    public abstract double get(int var1);

    public double apply(int i) {
        return this.get(i);
    }

    public abstract void set(int var1, double var2);

    public void update(int i, double x) {
        this.set(i, x);
    }

    public abstract void add(int var1, double var2);

    public abstract void sub(int var1, double var2);

    public abstract void mul(int var1, double var2);

    public abstract void div(int var1, double var2);

    public abstract Vector slice(int var1, int var2);

    @Override
    public Vector column(int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector copy() {
        return this.copy(0, this.size());
    }

    public abstract Vector copy(int var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    public static void copy(Vector src, int pos, Vector dest, int destPos, int length) {
        if (src instanceof Vector32) {
            Vector32 a = (Vector32)src;
            if (dest instanceof Vector32) {
                Vector32 b = (Vector32)dest;
                System.arraycopy(a.array, pos, b.array, destPos, length);
                return;
            }
        }
        if (src instanceof Vector64) {
            Vector64 a = (Vector64)src;
            if (dest instanceof Vector64) {
                Vector64 b = (Vector64)dest;
                System.arraycopy(a.array, pos, b.array, destPos, length);
                return;
            }
        }
        int i = 0;
        while (i < length) {
            dest.set(destPos + i, src.get(pos + i));
            ++i;
        }
    }

    public abstract double[] toArray(double[] var1);

    public abstract float[] toArray(float[] var1);

    public abstract void fill(int var1, int var2, double var3);

    public DenseMatrix diagflat() {
        int n = this.size();
        DenseMatrix matrix = DenseMatrix.zeros(this.scalarType(), n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, this.get(i));
        }
        return matrix;
    }

    static MemorySegment memory(float[] array, int offset, int length) {
        MemorySegment memory = MemorySegment.ofArray(array);
        if (offset != 0 || length != array.length) {
            long byteSize = 4L;
            memory = memory.asSlice((long)offset * byteSize, (long)length * byteSize);
        }
        return memory;
    }

    static MemorySegment memory(double[] array, int offset, int length) {
        MemorySegment memory = MemorySegment.ofArray(array);
        if (offset != 0 || length != array.length) {
            long byteSize = 8L;
            memory = memory.asSlice((long)offset * byteSize, (long)length * byteSize);
        }
        return memory;
    }

    public static Vector column(double[] array) {
        return Vector64.column(array, 0, array.length);
    }

    public static Vector column(float[] array) {
        return Vector32.column(array, 0, array.length);
    }

    public static Vector row(double[] array) {
        return Vector64.row(array, 0, array.length);
    }

    public static Vector row(float[] array) {
        return Vector32.row(array, 0, array.length);
    }

    public static Vector zeros(ScalarType scalarType, int length) {
        return switch (scalarType) {
            case ScalarType.Float64 -> Vector.column(new double[length]);
            case ScalarType.Float32 -> Vector.column(new float[length]);
            default -> throw new UnsupportedOperationException("Unsupported ScalarType: " + String.valueOf((Object)scalarType));
        };
    }

    public Vector zeros(int length) {
        return Vector.zeros(this.scalarType(), length);
    }

    public static Vector ones(ScalarType scalarType, int length) {
        return switch (scalarType) {
            case ScalarType.Float64 -> {
                double[] array = new double[length];
                Arrays.fill(array, 1.0);
                yield Vector.column(array);
            }
            case ScalarType.Float32 -> {
                float[] array = new float[length];
                Arrays.fill(array, 1.0f);
                yield Vector.column(array);
            }
            default -> throw new UnsupportedOperationException("Unsupported ScalarType: " + String.valueOf((Object)scalarType));
        };
    }

    public Vector ones(int length) {
        return Vector.ones(this.scalarType(), length);
    }

    public double min() {
        int length = this.size();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            min = Math.min(min, this.get(i));
        }
        return min;
    }

    public double max() {
        int length = this.size();
        double max = Double.MIN_VALUE;
        for (int i = 0; i < length; ++i) {
            max = Math.max(max, this.get(i));
        }
        return max;
    }

    public double sum() {
        int length = this.size();
        double s = 0.0;
        for (int i = 0; i < length; ++i) {
            s += this.get(i);
        }
        return s;
    }

    public double mean() {
        int length = this.size();
        return length > 0 ? this.sum() / (double)length : 0.0;
    }

    public abstract int softmax();

    public double asum() {
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> cblas_h.cblas_dasum(this.size(), this.memory, 1);
            case ScalarType.Float32 -> cblas_h.cblas_sasum(this.size(), this.memory, 1);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    public void axpy(double alpha, Vector x) {
        if (this.scalarType() != x.scalarType()) {
            throw new IllegalArgumentException("Different scalar type: " + String.valueOf((Object)x.scalarType()));
        }
        if (this.size() != x.size()) {
            throw new IllegalArgumentException("Different vector size: " + x.size());
        }
        switch (this.scalarType()) {
            case Float64: {
                cblas_h.cblas_daxpy(this.size(), alpha, x.memory, 1, this.memory, 1);
                break;
            }
            case Float32: {
                cblas_h.cblas_saxpy(this.size(), (float)alpha, x.memory, 1, this.memory, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
            }
        }
    }

    public double dot(Vector x) {
        if (this.scalarType() != x.scalarType()) {
            throw new IllegalArgumentException("Different scalar type: " + String.valueOf((Object)x.scalarType()));
        }
        if (this.size() != x.size()) {
            throw new IllegalArgumentException("Different vector size: " + x.size());
        }
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> cblas_h.cblas_ddot(this.size(), x.memory, 1, this.memory, 1);
            case ScalarType.Float32 -> cblas_h.cblas_sdot(this.size(), x.memory, 1, this.memory, 1);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    public double norm2() {
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> cblas_h.cblas_dnrm2(this.size(), this.memory, 1);
            case ScalarType.Float32 -> cblas_h.cblas_snrm2(this.size(), this.memory, 1);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    public double norm1() {
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> cblas_h.cblas_dasum(this.size(), this.memory, 1);
            case ScalarType.Float32 -> cblas_h.cblas_sasum(this.size(), this.memory, 1);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    public double normInf() {
        return Math.abs(this.get(this.iamax()));
    }

    @Override
    public Vector scale(double alpha) {
        switch (this.scalarType()) {
            case Float64: {
                cblas_h.cblas_dscal(this.size(), alpha, this.memory, 1);
                break;
            }
            case Float32: {
                cblas_h.cblas_sscal(this.size(), (float)alpha, this.memory, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
            }
        }
        return this;
    }

    public void swap(Vector x) {
        if (this.scalarType() != x.scalarType()) {
            throw new IllegalArgumentException("Different scalar type: " + String.valueOf((Object)x.scalarType()));
        }
        if (this.size() != x.size()) {
            throw new IllegalArgumentException("Different vector size: " + x.size());
        }
        switch (this.scalarType()) {
            case Float64: {
                cblas_h.cblas_dswap(this.size(), x.memory, 1, this.memory, 1);
                break;
            }
            case Float32: {
                cblas_h.cblas_sswap(this.size(), x.memory, 1, this.memory, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
            }
        }
    }

    public int iamax() {
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> (int)cblas_h.cblas_idamax(this.size(), this.memory, 1);
            case ScalarType.Float32 -> (int)cblas_h.cblas_isamax(this.size(), this.memory, 1);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }
}

