/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ProxySearchResultListener;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.GenericSASLBindRequest;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ProxyRequestHandler
extends LDAPListenerRequestHandler
implements IntermediateResponseListener {
    private static final long serialVersionUID = -8714030276701707669L;
    private final LDAPConnection ldapConnection;
    private final LDAPListenerClientConnection listenerConnection;
    private final ServerSet serverSet;

    public ProxyRequestHandler(ServerSet serverSet) {
        Validator.ensureNotNull(serverSet);
        this.serverSet = serverSet;
        this.ldapConnection = null;
        this.listenerConnection = null;
    }

    private ProxyRequestHandler(ServerSet serverSet, LDAPConnection ldapConnection, LDAPListenerClientConnection listenerConnection) {
        this.serverSet = serverSet;
        this.ldapConnection = ldapConnection;
        this.listenerConnection = listenerConnection;
    }

    @Override
    public ProxyRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new ProxyRequestHandler(this.serverSet, this.serverSet.getConnection(), connection);
    }

    @Override
    public void closeInstance() {
        this.ldapConnection.close();
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        LDAPResult addResult;
        AddRequest addRequest = new AddRequest(request.getDN(), request.getAttributes());
        if (!controls.isEmpty()) {
            addRequest.setControls(controls);
        }
        addRequest.setIntermediateResponseListener(this);
        try {
            addResult = this.ldapConnection.add(addRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            addResult = le.toLDAPResult();
        }
        AddResponseProtocolOp addResponseProtocolOp = new AddResponseProtocolOp(addResult.getResultCode().intValue(), addResult.getMatchedDN(), addResult.getDiagnosticMessage(), Arrays.asList(addResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)addResponseProtocolOp, Arrays.asList(addResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        LDAPResult bindResult;
        Control[] controlArray;
        if (controls == null || controls.isEmpty()) {
            controlArray = StaticUtils.NO_CONTROLS;
        } else {
            controlArray = new Control[controls.size()];
            controls.toArray(controlArray);
        }
        BindRequest bindRequest = request.getCredentialsType() == -128 ? new SimpleBindRequest(request.getBindDN(), request.getSimplePassword().getValue(), controlArray) : new GenericSASLBindRequest(request.getBindDN(), request.getSASLMechanism(), request.getSASLCredentials(), controlArray);
        bindRequest.setIntermediateResponseListener(this);
        try {
            bindResult = this.ldapConnection.bind(bindRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            bindResult = le.toLDAPResult();
        }
        BindResponseProtocolOp bindResponseProtocolOp = new BindResponseProtocolOp(bindResult.getResultCode().intValue(), bindResult.getMatchedDN(), bindResult.getDiagnosticMessage(), Arrays.asList(bindResult.getReferralURLs()), null);
        return new LDAPMessage(messageID, (ProtocolOp)bindResponseProtocolOp, Arrays.asList(bindResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        LDAPResult compareResult;
        CompareRequest compareRequest = new CompareRequest(request.getDN(), request.getAttributeName(), request.getAssertionValue().getValue());
        if (!controls.isEmpty()) {
            compareRequest.setControls(controls);
        }
        compareRequest.setIntermediateResponseListener(this);
        try {
            compareResult = this.ldapConnection.compare(compareRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            compareResult = le.toLDAPResult();
        }
        CompareResponseProtocolOp compareResponseProtocolOp = new CompareResponseProtocolOp(compareResult.getResultCode().intValue(), compareResult.getMatchedDN(), compareResult.getDiagnosticMessage(), Arrays.asList(compareResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)compareResponseProtocolOp, Arrays.asList(compareResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        LDAPResult deleteResult;
        DeleteRequest deleteRequest = new DeleteRequest(request.getDN());
        if (!controls.isEmpty()) {
            deleteRequest.setControls(controls);
        }
        deleteRequest.setIntermediateResponseListener(this);
        try {
            deleteResult = this.ldapConnection.delete(deleteRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            deleteResult = le.toLDAPResult();
        }
        DeleteResponseProtocolOp deleteResponseProtocolOp = new DeleteResponseProtocolOp(deleteResult.getResultCode().intValue(), deleteResult.getMatchedDN(), deleteResult.getDiagnosticMessage(), Arrays.asList(deleteResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)deleteResponseProtocolOp, Arrays.asList(deleteResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        ExtendedRequest extendedRequest;
        if (controls.isEmpty()) {
            extendedRequest = new ExtendedRequest(request.getOID(), request.getValue());
        } else {
            Control[] controlArray = new Control[controls.size()];
            controls.toArray(controlArray);
            extendedRequest = new ExtendedRequest(request.getOID(), request.getValue(), controlArray);
        }
        extendedRequest.setIntermediateResponseListener(this);
        try {
            ExtendedResult extendedResult = this.ldapConnection.processExtendedOperation(extendedRequest);
            ExtendedResponseProtocolOp extendedResponseProtocolOp = new ExtendedResponseProtocolOp(extendedResult.getResultCode().intValue(), extendedResult.getMatchedDN(), extendedResult.getDiagnosticMessage(), Arrays.asList(extendedResult.getReferralURLs()), extendedResult.getOID(), extendedResult.getValue());
            return new LDAPMessage(messageID, (ProtocolOp)extendedResponseProtocolOp, Arrays.asList(extendedResult.getResponseControls()));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            ExtendedResponseProtocolOp extendedResponseProtocolOp = new ExtendedResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getMessage(), Arrays.asList(le.getReferralURLs()), null, null);
            return new LDAPMessage(messageID, (ProtocolOp)extendedResponseProtocolOp, Arrays.asList(le.getResponseControls()));
        }
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        LDAPResult modifyResult;
        ModifyRequest modifyRequest = new ModifyRequest(request.getDN(), request.getModifications());
        if (!controls.isEmpty()) {
            modifyRequest.setControls(controls);
        }
        modifyRequest.setIntermediateResponseListener(this);
        try {
            modifyResult = this.ldapConnection.modify(modifyRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            modifyResult = le.toLDAPResult();
        }
        ModifyResponseProtocolOp modifyResponseProtocolOp = new ModifyResponseProtocolOp(modifyResult.getResultCode().intValue(), modifyResult.getMatchedDN(), modifyResult.getDiagnosticMessage(), Arrays.asList(modifyResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)modifyResponseProtocolOp, Arrays.asList(modifyResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        LDAPResult modifyDNResult;
        ModifyDNRequest modifyDNRequest = new ModifyDNRequest(request.getDN(), request.getNewRDN(), request.deleteOldRDN(), request.getNewSuperiorDN());
        if (!controls.isEmpty()) {
            modifyDNRequest.setControls(controls);
        }
        modifyDNRequest.setIntermediateResponseListener(this);
        try {
            modifyDNResult = this.ldapConnection.modifyDN(modifyDNRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            modifyDNResult = le.toLDAPResult();
        }
        ModifyDNResponseProtocolOp modifyDNResponseProtocolOp = new ModifyDNResponseProtocolOp(modifyDNResult.getResultCode().intValue(), modifyDNResult.getMatchedDN(), modifyDNResult.getDiagnosticMessage(), Arrays.asList(modifyDNResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)modifyDNResponseProtocolOp, Arrays.asList(modifyDNResult.getResponseControls()));
    }

    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        LDAPResult searchResult;
        String[] attrs;
        List<String> attrList = request.getAttributes();
        if (attrList.isEmpty()) {
            attrs = StaticUtils.NO_STRINGS;
        } else {
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        }
        ProxySearchResultListener searchListener = new ProxySearchResultListener(this.listenerConnection, messageID);
        SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, request.getBaseDN(), request.getScope(), request.getDerefPolicy(), request.getSizeLimit(), request.getTimeLimit(), request.typesOnly(), request.getFilter(), attrs);
        if (!controls.isEmpty()) {
            searchRequest.setControls(controls);
        }
        searchRequest.setIntermediateResponseListener(this);
        try {
            searchResult = this.ldapConnection.search(searchRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            searchResult = le.toLDAPResult();
        }
        SearchResultDoneProtocolOp searchResultDoneProtocolOp = new SearchResultDoneProtocolOp(searchResult.getResultCode().intValue(), searchResult.getMatchedDN(), searchResult.getDiagnosticMessage(), Arrays.asList(searchResult.getReferralURLs()));
        return new LDAPMessage(messageID, (ProtocolOp)searchResultDoneProtocolOp, Arrays.asList(searchResult.getResponseControls()));
    }

    @Override
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        try {
            this.listenerConnection.sendIntermediateResponse(intermediateResponse.getMessageID(), new IntermediateResponseProtocolOp(intermediateResponse.getOID(), intermediateResponse.getValue()), intermediateResponse.getControls());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }
}

