package com.franciaflex.faxtomail.ui.swing.content;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2016 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class MainUI extends JFrame implements FaxToMailUI<FaxToMailUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEMAND_LIST_BUTTON_SELECTED = "demandListButton.selected";
    public static final String BINDING_SEARCH_BUTTON_SELECTED = "searchButton.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXz28bRRSeOLZb54eSNm3UlgIb2kqJ1K5TpAikUGjsxMSRE1exCxE5hPHu2N50d2eZna03ioL4E/gT4AwXJG6cEAfOHLgg/gWEOPSKeDO72bWd3do5YFmbaN5733zv2/fejL//C+VchpaOse+rzLO5YRF1Z+PgoN46JhrfJK7GDIdThoLPRAZlDtG0Hq27HN07rInwYhheLFPLoTax+6LXa2jK5ScmcbuEcI7eHIzQXLfYiMzrvuOxc9SIVBLqN//8nfla/+rbDEK+A+ymIRVlVFScSbaGMobO0XXY6SUumtjuAA1m2B3gOyvWyiZ23T1skS/Ql+hKDeUdzACMo3fGT1liyHjf4ahgYcOuMIDk6LFGLbXNsK0ZuG0SX21jn1NwMFXPUN0eEFE1anPAVXch7HnVcSRSnqOcRXVicrQ2BkYF+00KAObzalnA+TzGyXPqlDDj6IbI1w8jdpqUmrAsnAqR77xOLGzrNcPlJY9zgEK3h6I6HZMENhEzF4XOuAQzrRubbgzap+9HEq7CCxGoKu7x+P0NuhdaFICskOG1QZqLL7Fp6BjewS5xXdwhnxp6R1Td+wOlEXmF7Bvi+UliqAC+E3PFLepFCiwMKBAnGPtnW1Q/4WiJso56DJ3zAiQP/H1156BpcJPoz7BNzME08i7H3IP+ejBAOyQrbSHJ/mCG3hhwh9ZS49aKa3/iEOWYB8sc3Tq82I37YAr68NZQHwpAaf13ceH3n/78sXLefLOw981E177ZAU3hMOoQxg2x9VzQeR43zOIudtYPUcElJgweOVjuJhBrhGYgB/tdk4UiwtVt7HYBInflj59/Wfz8t0mUqaApk2K9goV/FRV4l4EK1NR956OnktFM7yo85wU30LtFmQ7EUPFUKcl/g8gTVWMEc7JlOfwkMCyvPlTWHiriuaKc+aDS3QSVIqqtwq+vFho/PD1XagKY3051j9XKfYbyhm0aNpGDKpxBiYNp2nGJp9N41iRNHwTzZ2qnQWCIiRIPh8Aj+XycJMmchX3D8qx92itTT8y9zLurvif818AjIyPfE7CLJYLtimFywnALdqVWi5aoH24hXWaEy5Ahbe8MDDguGoOj+/FAE6NTlcsqdhzT0DA3qL0nZ+lNnbSxZ/KySV1ShwKTNqih0x05bdXN+tFevbld3fv4qL53VK7VG1tncSoTIc/+Ae2MIDkJzm2oMC4yBsJtbLrwN29h1jFg66VTm/SUaJRVbbC6y2uydMR35Yyj2aDonsGenOjnIEm8wkE9ilSOo6tBCwm4R6eKPCdUGGINKGNiL68oT54o0YkQLKq1aqOpAJ2sOByA+ZDm0AcgphqMfyLmPxRSsFgVBxTKmnLt+lHfe9nQgjewfTrGERWAQRN0aW8z3ibAUDVRxEBvmsOx1DScpmT5YCRLKBYnScsLB9nlVC2OqWpja2O/vN2n69vJjBnRugRORzKkaj44NFN0rVxW1/3zbV6r6r0RHNM0HTjhR+mZjSS5k7wd8Y0LNRasJWpRvYwWckRsDIOkyPFWOr80JaaEcTwdJodyzMmrRUqSpcu+8A0B9trsUgpSskhLr//68/+MyFV5tK5eekTGt8JRvOBsm2lTzXPHQE25To7aAo6wAtw2elBt2os49XmxtkssuFc0wvtdljMveeQHN8Axksl3idHpisL5ILgwKJjDD5mWx8mHF5AnxHNqDNRcD34ddYX5u3SQ/wCOCEKOQg4AAA==";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton aboutButton;
    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected JToggleButton demandListButton;
    protected final MainUIHandler handler = createHandler();
    protected MainUI mainFrame = this;
    protected FaxToMailUIContext model;
    protected JToggleButton searchButton;
    protected StatusMessagePanel status;
    protected JToolBar topBar;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Component $Component0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(FaxToMailUIContext context) {
        FaxToMailUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAboutButton() {
        return aboutButton;
    }

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public JToggleButton getDemandListButton() {
        return demandListButton;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public FaxToMailUIContext getModel() {
        return model;
    }

    public JToggleButton getSearchButton() {
        return searchButton;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public JToolBar getTopBar() {
        return topBar;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Component get$Component0() {
        return $Component0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
        bottomBar.add(aboutButton);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(topBar, BorderLayout.NORTH);
        add(bottomBar);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
    }

    protected void addChildrenToTopBar() {
        if (!allComponentsCreated) {
            return;
        }
        topBar.add(demandListButton);
        topBar.add(searchButton);
        topBar.add($Component0);
    }

    protected void createAboutButton() {
        $objectMap.put("aboutButton", aboutButton = new JButton());
        
        aboutButton.setName("aboutButton");
        aboutButton.setToolTipText(t("faxtomail.main.action.about.tip"));
        aboutButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowAboutAction.class);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createDemandListButton() {
        $objectMap.put("demandListButton", demandListButton = new JToggleButton());
        
        demandListButton.setName("demandListButton");
        demandListButton.setText(t("faxtomail.main.action.demandeList"));
        demandListButton.setToolTipText(t("faxtomail.main.action.demandeList.tip"));
        demandListButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeListAction.class);
    }

    protected MainUIHandler createHandler() {
        return new MainUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FaxToMailUIContext.class));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JToggleButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(t("faxtomail.main.action.recherche"));
        searchButton.setToolTipText(t("faxtomail.main.action.recherche.tip"));
        searchButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowRechercheAction.class);
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
        status.setShowClock(false);
        status.setShowMemoryStatus(true);
    }

    protected void createTopBar() {
        $objectMap.put("topBar", topBar = new JToolBar());
        
        topBar.setName("topBar");
        topBar.setFloatable(false);
        topBar.setBorderPainted(false);
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToTopBar();
        addChildrenToBottomBar();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        topBar.setMargin(new java.awt.Insets(5, 5, 5, 5));
        demandListButton.setIcon(SwingUtil.createActionIcon("list"));
        searchButton.setIcon(SwingUtil.createActionIcon("search"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        aboutButton.setIcon(SwingUtil.createActionIcon("about"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createTopBar();
        createDemandListButton();
        createSearchButton();
        // inline creation of $Component0
        $objectMap.put("$Component0", $Component0 = Box.createHorizontalGlue());
        
        $Component0.setName("$Component0");
        createBottomBar();
        createValidatorMessageWidget();
        createAboutButton();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,780);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("faxtomail.main.title.applicationName"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMAND_LIST_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    demandListButton.setSelected( model.getScreen() == FaxToMailScreen.LIST );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SEARCH_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    searchButton.setSelected( model.getScreen() == FaxToMailScreen.SEARCH );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
    }

}