/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class EmailGroupAbstract
extends AbstractTopiaEntity
implements EmailGroup {
    protected Collection<Email> email;
    private static final long serialVersionUID = 7075266499924539238L;

    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "email", Collection.class, Email.class, this.email);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void addEmail(Email email) {
        this.fireOnPreWrite("email", null, email);
        if (this.email == null) {
            this.email = new LinkedList<Email>();
        }
        email.setEmailGroup(this);
        this.email.add(email);
        this.fireOnPostWrite("email", this.email.size(), null, email);
    }

    @Override
    public void addAllEmail(Collection<Email> email) {
        if (email == null) {
            return;
        }
        for (Email item : email) {
            this.addEmail(item);
        }
    }

    @Override
    public void setEmail(Collection<Email> email) {
        LinkedList<Email> oldValue = this.email != null ? new LinkedList<Email>(this.email) : null;
        this.fireOnPreWrite("email", oldValue, email);
        this.email = email;
        this.fireOnPostWrite("email", oldValue, email);
    }

    @Override
    public void removeEmail(Email email) {
        this.fireOnPreWrite("email", email, null);
        if (this.email == null || !this.email.remove(email)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        email.setEmailGroup(null);
        this.fireOnPostWrite("email", this.email.size() + 1, email, null);
    }

    @Override
    public void clearEmail() {
        if (this.email == null) {
            return;
        }
        for (Email item : this.email) {
            item.setEmailGroup(null);
        }
        LinkedList<Email> oldValue = new LinkedList<Email>(this.email);
        this.fireOnPreWrite("email", oldValue, this.email);
        this.email.clear();
        this.fireOnPostWrite("email", oldValue, this.email);
    }

    @Override
    public Collection<Email> getEmail() {
        return this.email;
    }

    @Override
    public Email getEmailByTopiaId(String topiaId) {
        return (Email)TopiaEntityHelper.getEntityByTopiaId(this.email, (String)topiaId);
    }

    @Override
    public Collection<String> getEmailTopiaIds() {
        LinkedList<String> topiaIds = new LinkedList<String>();
        Collection<Email> tmp = this.getEmail();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeEmail() {
        if (this.email == null) {
            return 0;
        }
        return this.email.size();
    }

    @Override
    public boolean isEmailEmpty() {
        int size = this.sizeEmail();
        return size == 0;
    }

    @Override
    public boolean isEmailNotEmpty() {
        boolean empty = this.isEmailEmpty();
        return !empty;
    }

    @Override
    public boolean containsEmail(Email email) {
        boolean contains = this.email != null && this.email.contains(email);
        return contains;
    }
}

