package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.*;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n.t;

/**
 * To show demande screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class ShowDemandeAction extends AbstractChangeScreenAction {

    public ShowDemandeAction(MainUIHandler handler) {
        super(handler, true, FaxToMailScreen.DEMANDE);
        setActionDescription(t("faxtomail.action.goto.demand.tip"));
    }

    @Override
    public void doAction() throws Exception {
        super.doAction();

        DemandeUIModel currentEmail = getContext().getCurrentEmail();
        if (StringUtils.isNoneBlank(currentEmail.getTopiaId())) {
            Email email = getContext().getEmailService().getEmailById(currentEmail.getTopiaId());
            currentEmail.setGroupedDemandes(email.getEmailGroup());
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        DemandeUIModel currentEmail = getContext().getCurrentEmail();
        FaxToMailUser takenBy = currentEmail.getTakenBy();
        FaxToMailUser currentUser = getContext().getCurrentUser();

        if (currentEmail.getArchiveDate() != null) {
            currentEmail.setEditable(false);

        } else if (takenBy != null && !currentUser.equals(takenBy)) {
            String htmlMessage = String.format(
                    AbstractApplicationUIHandler.CONFIRMATION_FORMAT,
                    t("faxtomail.alert.alreadyTakenBy.message", decorate(takenBy)),
                    t("faxtomail.alert.alreadyTakenBy.help"));

            int result = JOptionPane.showConfirmDialog(getHandler().getTopestUI(),
                                                        htmlMessage,
                                                        t("faxtomail.alert.alreadyTakenBy.title"),
                                                        JOptionPane.YES_NO_CANCEL_OPTION,
                                                        JOptionPane.QUESTION_MESSAGE);

            switch (result) {
                case JOptionPane.CANCEL_OPTION:
                    getContext().setScreen(FaxToMailScreen.LIST);
                    break;

                case JOptionPane.NO_OPTION:
                    currentEmail.setEditable(false);
                    break;

                case JOptionPane.YES_OPTION:
                    Email email = getContext().getEmailService().takeEmail(currentEmail.getTopiaId(), currentUser);
                    currentEmail.fromEntity(email);
                    currentEmail.setEditable(true);
                    break;
            }
        }
    }
}
