package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ReplyAction.java 86 2014-05-21 19:30:41Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/ReplyAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ReplyAction extends AbstractFaxToMailAction<ReplyFormUIModel, ReplyFormUI, ReplyFormUIHandler> {

    private static final Log log = LogFactory.getLog(ReplyAction.class);
    private EmailService emailService;

    public ReplyAction(ReplyFormUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.reply.tip"));
    }

    @Override
    public void doAction() throws Exception {
        log.info("do reply");

        ReplyFormUIModel model = getModel();
        emailService = getContext().getEmailService();
        DemandeUIModel originalDemand = getModel().getOriginalDemand();

        Email email = emailService.reply(model.getFrom(),
                                          model.getTo(),
                                          model.getSubject(),
                                          model.getMessage(),
                                          model.getAttachments(),
                                          originalDemand.getTopiaId(),
                                          getContext().getCurrentUser());

        originalDemand.fromEntity(email);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        handler.closeFrame();
    }
}
