/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service.ldap;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.services.service.LdapServiceImpl;
import com.franciaflex.faxtomail.services.service.ldap.AuthenticationException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class LdapServiceMock
extends LdapServiceImpl {
    protected FaxToMailUser getFakeFaxToMailUser() {
        FaxToMailUserTopiaDao userDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUserGroupTopiaDao groupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        FaxToMailUser fakeUser = (FaxToMailUser)userDao.forAll().setOrderByArguments(new String[]{"topiaId"}).findFirstOrNull();
        if (fakeUser == null) {
            fakeUser = new FaxToMailUserImpl();
            fakeUser.setTrigraph("fkr");
            fakeUser.setFirstName("Test ldap");
            fakeUser.setLastName("Test ldap");
            fakeUser.setLogin("test");
            fakeUser = (FaxToMailUser)userDao.create((TopiaEntity)fakeUser);
        }
        FaxToMailUserGroup fakeGroup = null;
        List adminGroups = this.getApplicationConfig().getLdapAdminGroups();
        if (CollectionUtils.isNotEmpty((Collection)adminGroups)) {
            fakeGroup = (FaxToMailUserGroup)groupDao.forCompleteNameEquals((String)adminGroups.get(0)).findAnyOrNull();
            if (fakeGroup == null) {
                fakeGroup = new FaxToMailUserGroupImpl();
                fakeGroup.setName("fake group");
                fakeGroup.setCompleteName((String)adminGroups.get(0));
                fakeGroup = (FaxToMailUserGroup)groupDao.create((TopiaEntity)fakeGroup);
            }
            if (!fakeUser.containsUserGroups(fakeGroup)) {
                fakeUser.addUserGroups(fakeGroup);
            }
        }
        this.getPersistenceContext().commit();
        return fakeUser;
    }

    @Override
    public void updateLdapData() {
    }

    @Override
    public FaxToMailUser getUserBean(String userTopiaId) {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser result = (FaxToMailUser)faxtomailUserDao.forTopiaIdEquals(userTopiaId).findUnique();
        result.isAffectedFoldersEmpty();
        result.isUserGroupsEmpty();
        return result;
    }

    @Override
    public FaxToMailUser authenticateUser(String login, String password) throws AuthenticationException {
        return this.getUserFromPrincipal(login);
    }

    @Override
    public FaxToMailUser getUserFromPrincipal(String principal) throws AuthenticationException {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser result = (FaxToMailUser)faxtomailUserDao.forLoginEquals(principal.toLowerCase()).findUniqueOrNull();
        if (result == null) {
            result = this.getFakeFaxToMailUser();
        }
        result.isAffectedFoldersEmpty();
        result.isUserGroupsEmpty();
        result.isSigningsEmpty();
        return result;
    }
}

