/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EdiReturn;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailLock;
import com.franciaflex.faxtomail.persistence.entities.MailLockImpl;
import com.franciaflex.faxtomail.persistence.entities.MailLockTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.PriorityTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.RangeRowTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.RangeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.persistence.entities.ReplyContentTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.ReplyTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.SearchFilter;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.services.service.exceptions.InvalidClientException;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportBean;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportModel;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.hibernate.Hibernate;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class EmailServiceImpl
extends FaxToMailServiceSupport
implements EmailService {
    private static final Log log = LogFactory.getLog(EmailServiceImpl.class);
    protected Binder<Attachment, Attachment> attachmentBinder = BinderFactory.newBinder(Attachment.class, Attachment.class);

    @Override
    public Email getEmailById(String id) {
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).findUnique();
        return email;
    }

    protected Email getEmailById(String id, String fetch, String ... otherFetches) {
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).addAllFetches(fetch, otherFetches).findUnique();
        return email;
    }

    @Override
    public Email getFullEmailById(String id) {
        EmailGroup emailGroup;
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).addAllFetches("demandType", new String[]{"takenBy", "client", "waitingState", "priority"}).findUnique();
        List rangeRows = email.getRangeRow();
        if (rangeRows != null) {
            for (RangeRow rangeRow : rangeRows) {
                Hibernate.initialize((Object)rangeRow.getRange());
            }
        }
        Hibernate.initialize((Object)email.getReplies());
        Hibernate.initialize((Object)email.getAttachment());
        List histories = email.getHistory();
        if (histories != null) {
            for (History history : histories) {
                Hibernate.initialize((Object)history.getFaxToMailUser());
            }
        }
        if ((emailGroup = email.getEmailGroup()) != null) {
            Set emails = emailGroup.getEmail();
            for (Email email2 : emails) {
                Hibernate.initialize((Object)email2.getMailFolder());
            }
        }
        return email;
    }

    @Override
    public Email getFullEmailById(String id, FaxToMailUser user) {
        Email email = this.getFullEmailById(id);
        MailFolderService mailFolderService = this.serviceContext.getMailFolderService();
        MailFolder folder = email.getMailFolder();
        this.browseFolderParent(folder, user, mailFolderService);
        return email;
    }

    protected void browseFolderParent(MailFolder folder, FaxToMailUser user, MailFolderService mailFolderService) {
        boolean readable;
        boolean writable;
        Hibernate.initialize((Object)folder);
        Hibernate.initialize((Object)folder.getChildren());
        mailFolderService.fetchFolderAttributes(folder);
        MailFolder parent = folder.getParent();
        if (parent != null) {
            this.browseFolderParent(parent, user, mailFolderService);
        }
        boolean bl = writable = parent != null && parent.isFolderWritable();
        if (folder.getWriteRightGroups() != null && user.getUserGroups() != null) {
            writable |= CollectionUtils.containsAny((Collection)folder.getWriteRightGroups(), (Collection)user.getUserGroups());
        }
        writable |= folder.containsWriteRightUsers(user);
        boolean bl2 = readable = parent != null && parent.isFolderReadable();
        if (folder.getReadRightGroups() != null && user.getUserGroups() != null) {
            readable |= CollectionUtils.containsAny((Collection)folder.getReadRightGroups(), (Collection)user.getUserGroups());
        }
        folder.setFolderWritable(writable);
        folder.setFolderReadable(readable |= folder.containsReadRightUsers(user));
    }

    @Override
    public Email saveEmail(Email email, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        Client client = email.getClient();
        return this.saveEmail(email, null, null, client != null ? client.getCode() : null, user, modifiedFields);
    }

    @Override
    public Email saveEmail(Email email, Collection<Attachment> attachments, Collection<Reply> replies, String clientCode, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        Date now = this.getNow();
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        MailFolder folder = email.getMailFolder();
        while (!folder.isUseCurrentLevelCompany() && folder.getParent() != null) {
            folder = folder.getParent();
        }
        String company = folder.getCompany();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)clientCode)) {
            Client emailClient = email.getClient();
            if (emailClient != null && clientCode.equals(email.getClient().getCode())) {
                client = emailClient;
            } else {
                client = this.getClientService().getClientForCode(clientCode, company);
                if (client == null) {
                    String message = I18n.t((String)"faxtomail.service.email.save.clientCode.error", (Object[])new Object[]{clientCode});
                    throw new InvalidClientException(message);
                }
            }
        }
        email.setClient(client);
        if (attachments != null) {
            this.updateAttachments(email, attachments);
        }
        if (replies != null) {
            this.updateReplies(email);
        }
        if (email.getRangeRow() != null) {
            RangeRowTopiaDao rangeRowDao = this.getPersistenceContext().getRangeRowDao();
            for (RangeRow rangeRow : email.getRangeRow()) {
                if (!rangeRow.isPersisted()) {
                    rangeRowDao.create((TopiaEntity)rangeRow);
                    continue;
                }
                rangeRowDao.update((TopiaEntity)rangeRow);
            }
        }
        if (!email.isPersisted()) {
            if (email.getHistory() != null) {
                historyDao.createAll((Iterable)email.getHistory());
            }
            email = (Email)dao.create((TopiaEntity)email);
        }
        HashSet fieldSet = Sets.newHashSet((Object[])modifiedFields);
        History transmissionToEdi = (History)CollectionUtils.find((Iterable)email.getHistory(), (Predicate)new Predicate<History>(){

            public boolean evaluate(History object) {
                return object.getType() == HistoryType.TRANSMISSION_TO_EDI;
            }
        });
        if (transmissionToEdi == null && email.getClient() != null && email.getDemandType() != null && StringUtils.isNotBlank((CharSequence)email.getProjectReference())) {
            this.handleEdiTransmission(email, historyDao, fieldSet);
        }
        History history = null;
        if (fieldSet.contains("archiveDate")) {
            history = (History)historyDao.create("type", (Object)HistoryType.ARCHIVED, new Object[]{"faxToMailUser", user, "modificationDate", now});
        } else if (fieldSet.contains("mailFolder")) {
            history = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION, new Object[]{"faxToMailUser", user, "modificationDate", now});
        } else {
            boolean historyEmpty;
            if (email.getTakenBy() == null && !fieldSet.isEmpty() && !fieldSet.contains("takenBy")) {
                email.setTakenBy(user);
                fieldSet.add("takenBy");
            }
            if ((historyEmpty = email.isHistoryEmpty()) || !fieldSet.isEmpty()) {
                history = (History)historyDao.create("type", (Object)(historyEmpty ? HistoryType.CREATION : HistoryType.MODIFICATION), new Object[]{"faxToMailUser", user, "modificationDate", now});
                history.setFields((Set)fieldSet);
            }
        }
        if (history != null) {
            email.addHistory(history);
        }
        Email result = (Email)dao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return result;
    }

    protected void updateReplies(Email email) {
        ReplyTopiaDao replyTopiaDao = this.getPersistenceContext().getReplyDao();
        ArrayList currentReplies = new ArrayList(email.getReplies());
        email.clearReplies();
        for (Reply reply : currentReplies) {
            Reply newReply = (Reply)replyTopiaDao.forTopiaIdEquals(reply.getTopiaId()).findUnique();
            email.addReplies(newReply);
        }
    }

    protected void updateAttachments(Email email, Collection<Attachment> attachments) {
        AttachmentTopiaDao attachmentTopiaDao = this.getPersistenceContext().getAttachmentDao();
        ArrayList<AttachmentImpl> currentAttachments = attachmentTopiaDao.forTopiaIdIn((Collection)email.getAttachmentTopiaIds()).findAll();
        if (currentAttachments == null) {
            currentAttachments = new ArrayList<AttachmentImpl>();
        }
        HashMap currentAttachmentIndex = new HashMap(Maps.uniqueIndex(currentAttachments, (Function)TopiaEntities.getTopiaIdFunction()));
        AttachmentFileTopiaDao attachementFileTopiaDao = this.getPersistenceContext().getAttachmentFileDao();
        for (Attachment attachment : attachments) {
            Object currentAttachment = StringUtils.isNotBlank((CharSequence)attachment.getTopiaId()) ? (Attachment)currentAttachmentIndex.remove(attachment.getTopiaId()) : new AttachmentImpl();
            AttachmentFile originalFile = null;
            AttachmentFile editedFile = null;
            originalFile = attachment.getOriginalFile() != null ? attachment.getOriginalFile() : currentAttachment.getOriginalFile();
            editedFile = attachment.getEditedFile() != null ? attachment.getEditedFile() : currentAttachment.getEditedFile();
            this.attachmentBinder.copyExcluding((Object)attachment, currentAttachment, new String[]{"editedFile", "editedFileName", "originalFile", "originalFileName", "topiaCreateDate", "topiaId", "topiaVersion"});
            currentAttachment.setEditedFile(editedFile);
            currentAttachment.setOriginalFile(originalFile);
            if (!originalFile.isPersisted()) {
                attachementFileTopiaDao.create((TopiaEntity)originalFile);
            } else {
                attachementFileTopiaDao.update((TopiaEntity)originalFile);
            }
            if (editedFile != null) {
                if (!editedFile.isPersisted()) {
                    attachementFileTopiaDao.create((TopiaEntity)editedFile);
                } else {
                    attachementFileTopiaDao.update((TopiaEntity)editedFile);
                }
            }
            if (currentAttachment.isPersisted()) continue;
            currentAttachments.add((AttachmentImpl)currentAttachment);
        }
        for (Attachment attachment : currentAttachmentIndex.values()) {
            currentAttachments.remove(attachment);
        }
        email.setAttachment(currentAttachments);
    }

    protected void handleEdiTransmission(Email email, HistoryTopiaDao historyDao, Set<String> fieldSet) {
        if (FaxToMailServiceUtils.contains(email.getDemandType().getRequiredFields(), MailField.RANGE_ROW) && email.getDemandType().isEdiTransfer()) {
            if (email.isRangeRowNotEmpty()) {
                Boolean ediTranfer = null;
                MailFolder loopFolder = email.getMailFolder();
                do {
                    ediTranfer = loopFolder.getEdiTransfer();
                    loopFolder = loopFolder.getParent();
                } while (ediTranfer == null && loopFolder != null);
                if (BooleanUtils.isTrue((Boolean)ediTranfer)) {
                    History transmissionToEdi = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION_TO_EDI, new Object[]{"modificationDate", new Date()});
                    email.addHistory(transmissionToEdi);
                    email.setDemandStatus(DemandStatus.TRANSMISSION_TO_EDI);
                    fieldSet.add("demandStatus");
                } else {
                    History transmissionToEdi = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION_TO_EDI, new Object[]{"modificationDate", new Date()});
                    email.addHistory(transmissionToEdi);
                    email.setDemandStatus(DemandStatus.IN_PROGRESS);
                    fieldSet.add("demandStatus");
                }
            }
        } else {
            History transmissionToEdi = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION_TO_EDI, new Object[]{"modificationDate", new Date()});
            email.addHistory(transmissionToEdi);
            email.setDemandStatus(DemandStatus.IN_PROGRESS);
            fieldSet.add("demandStatus");
        }
    }

    @Override
    public void transmitPendingDemandsToEdi() {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        List toTransmitToEdi = dao.forDemandStatusEquals(DemandStatus.TRANSMISSION_TO_EDI).findAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(toTransmitToEdi.size() + " demands to transmit to edi"));
        }
        for (Email email : toTransmitToEdi) {
            this.transmitDemandToEdi(email);
        }
    }

    protected void transmitDemandToEdi(Email email) {
        Preconditions.checkArgument((email.getDemandStatus() == DemandStatus.TRANSMISSION_TO_EDI ? 1 : 0) != 0);
        Preconditions.checkArgument((!email.getRangeRow().isEmpty() ? 1 : 0) != 0);
        MailFolder folder = email.getMailFolder();
        while (!folder.isUseCurrentLevelEdiFolder() && folder.getParent() != null) {
            folder = folder.getParent();
        }
        String ediFolder = folder.getEdiFolder();
        if (StringUtils.isBlank((CharSequence)ediFolder)) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)("Aucun dossier de depot des demandes EDI d\u00e9fini pour le dossier " + folder.getName()));
            }
            return;
        }
        File ediFolderDirectory = new File(ediFolder);
        if (!ediFolderDirectory.canWrite()) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)("Le dossier " + ediFolderDirectory.getAbsolutePath() + " ne dispose pas des droits d'\u00e9criture !"));
            }
            return;
        }
        Date now = this.serviceContext.getNow();
        String fileDate = DateFormatUtils.format((Date)now, (String)"yyMMddHHmmss");
        for (RangeRow rangeRow : email.getRangeRow()) {
            String fileName = "ORD_FAX_" + fileDate + "_" + rangeRow.getTopiaId() + ".txt";
            File ediFile = new File(ediFolderDirectory, fileName);
            String separator = ";";
            try {
                BufferedWriter ediWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ediFile), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    ediWriter.write("%BEGIN_ENTETE_QUOTE\n");
                    ediWriter.write("E" + separator);
                    ediWriter.write("OARFAX" + separator);
                    ediWriter.write(DateFormatUtils.format((Date)now, (String)"ddMMyy") + separator);
                    ediWriter.write(DateFormatUtils.format((Date)email.getReceptionDate(), (String)"ddMMyy") + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(Strings.nullToEmpty((String)email.getProjectReference()) + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write("EUR" + separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getDemandType().getLabel() + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(rangeRow.getRange().getLabel() + separator);
                    ediWriter.write(rangeRow.getTopiaId() + "\n");
                    ediWriter.write("%END_ENTETE_QUOTE\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ediWriter == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)ediWriter).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)ediWriter).close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't generate EDI file");
            }
        }
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        email.setDemandStatus(DemandStatus.TRANSMITTED_TO_EDI);
        dao.update((TopiaEntity)email);
    }

    @Override
    public Set<Object> getDistinctValues(MailFolder folder, String[] properties, boolean sum) {
        Set result = null;
        if (folder.isFolderReadable()) {
            EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
            result = dao.getDistinctValues(folder, properties, sum);
        }
        return result;
    }

    @Override
    public PaginationResult<Email> getEmailForFolder(MailFolder folder, FaxToMailUser currentUser, EmailFilter filter, PaginationParameter page) {
        PaginationResult result;
        if (folder.isFolderReadable()) {
            EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
            result = dao.getEmailForFolder(filter, folder, page);
        } else {
            List elements = Collections.emptyList();
            result = PaginationResult.of(elements, (long)0L, (PaginationParameter)page);
        }
        return result;
    }

    @Override
    public List<MailFolder> getChildrenRecursively(MailFolder folder) {
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        folders.add(folder);
        Collection children = folder.getChildren();
        if (children != null) {
            for (MailFolder child : children) {
                folders.addAll(this.getChildrenRecursively(child));
            }
        }
        return folders;
    }

    @Override
    public Map<Range, Long[]> computeQuantitiesByRange(MailFolder rootFolder) {
        List<MailFolder> folders = this.getChildrenRecursively(rootFolder);
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Map daoResult = emailDao.computeQuantitiesByRange(folders);
        RangeTopiaDao rangeDao = this.getPersistenceContext().getRangeDao();
        TreeMap<Range, Long[]> result = new TreeMap<Range, Long[]>(new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        for (Map.Entry entry : daoResult.entrySet()) {
            Range range = (Range)rangeDao.forTopiaIdEquals((String)entry.getKey()).findUnique();
            result.put(range, (Long[])entry.getValue());
        }
        return result;
    }

    @Override
    public Email addToHistory(String emailId, HistoryType type, FaxToMailUser user, Date date, String ... fields) {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = this.getEmailById(emailId, "history.faxToMailUser", new String[0]);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)type, new Object[]{"faxToMailUser", user, "modificationDate", date});
        history.setFields((Set)Sets.newHashSet((Object[])fields));
        email.addHistory(history);
        if (type == HistoryType.ATTACHMENT_OPENING) {
            email.setLastAttachmentOpener(user);
        }
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    @Override
    public Email openEmail(String emailId, FaxToMailUser user, boolean takeEmail) throws FolderNotReadableException {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = this.getFullEmailById(emailId, user);
        MailFolder mailFolder = email.getMailFolder();
        if (!mailFolder.isFolderReadable()) {
            throw new FolderNotReadableException(String.format("Mail folder %s not readable by %s", mailFolder.getName(), user.getLogin()), mailFolder);
        }
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.OPENING, new Object[]{"faxToMailUser", user, "modificationDate", new Date()});
        email.addHistory(history);
        if (takeEmail) {
            history = (History)historyDao.create("type", (Object)HistoryType.MODIFICATION, new Object[]{"faxToMailUser", user, "modificationDate", new Date()});
            history.setFields((Set)Sets.newHashSet((Object[])new String[]{"takenBy"}));
            email.addHistory(history);
            email.setTakenBy(user);
        }
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    @Override
    public Email lockEmail(String emailId, FaxToMailUser currentUser) throws AlreadyLockedMailException, FolderNotReadableException {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        Email email = (Email)emailDao.forTopiaIdEquals(emailId).findUnique();
        MailFolderService mailFolderService = this.serviceContext.getMailFolderService();
        MailFolder folder = email.getMailFolder();
        this.browseFolderParent(folder, currentUser, mailFolderService);
        if (!folder.isFolderReadable()) {
            throw new FolderNotReadableException(String.format("Mail folder %s not readable by %s", folder.getName(), currentUser.getLogin()), folder);
        }
        Hibernate.initialize((Object)email.getTakenBy());
        MailLock mailLock = (MailLock)mailLockDao.forLockOnEquals(email).findUniqueOrNull();
        if (mailLock == null) {
            List mailLocksToRemove = email.getEmailGroup() != null ? mailLockDao.forLockByEquals(currentUser).addNotEquals("lockOn.emailGroup", (Object)email.getEmailGroup()).findAll() : mailLockDao.forLockByEquals(currentUser).findAll();
            if (log.isDebugEnabled()) {
                for (MailLock mailLockToRemove : mailLocksToRemove) {
                    log.debug((Object)("[UNLOCK] " + mailLockToRemove.getLockOn().getTopiaId() + " unlocked (automatic)"));
                }
            }
            mailLockDao.deleteAll((Iterable)mailLocksToRemove);
            mailLock = new MailLockImpl();
            mailLock.setLockBy(currentUser);
            mailLock.setLockOn(email);
            mailLock = (MailLock)mailLockDao.create((TopiaEntity)mailLock);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[LOCK] " + emailId + " locked by " + currentUser.getLogin()));
            }
            this.getPersistenceContext().commit();
        } else if (!mailLock.getLockBy().equals(currentUser)) {
            throw new AlreadyLockedMailException(String.format("Mail %s already locked by %s", emailId, mailLock.getLockBy().getTopiaId()), mailLock.getLockBy());
        }
        return email;
    }

    @Override
    public void unlockEmail(String emailId) {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        MailLock mailLock = (MailLock)mailLockDao.forAll().addEquals("lockOn.topiaId", (Object)emailId).findUniqueOrNull();
        if (mailLock != null) {
            mailLockDao.delete(mailLock);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[UNLOCK] " + emailId + " unlocked"));
            }
            this.getPersistenceContext().commit();
        }
    }

    protected void computeUserReadableFolder(Set<MailFolder> readMailFolders, Iterable<MailFolder> mailFolders) {
        if (mailFolders != null) {
            for (MailFolder mailFolder : mailFolders) {
                readMailFolders.add(mailFolder);
                this.computeUserReadableFolder(readMailFolders, mailFolder.getChildren());
            }
        }
    }

    @Override
    public PaginationResult<Email> search(SearchFilter emailFilter, FaxToMailUser user, PaginationParameter pagination) {
        MailFolderTopiaDao mailFolderDao = this.getPersistenceContext().getMailFolderDao();
        HashSet<MailFolder> readMailFolders = new HashSet<MailFolder>();
        List mailFolders = mailFolderDao.forReadRightUsersContains(user).findAll();
        this.computeUserReadableFolder(readMailFolders, mailFolders);
        if (user.getUserGroups() != null) {
            for (FaxToMailUserGroup group : user.getUserGroups()) {
                mailFolders = mailFolderDao.forReadRightGroupsContains(group).findAll();
                this.computeUserReadableFolder(readMailFolders, mailFolders);
            }
        }
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        PaginationResult result = emailDao.search(emailFilter, readMailFolders, pagination);
        return result;
    }

    @Override
    public Email groupEmails(String email1Id, String email2Id, FaxToMailUser user) {
        EmailGroupTopiaDao groupDao = this.getPersistenceContext().getEmailGroupDao();
        Email email1 = this.getFullEmailById(email1Id, user);
        Email email2 = this.getEmailById(email2Id);
        EmailGroup group1 = email1.getEmailGroup();
        EmailGroup group2 = email2.getEmailGroup();
        if (group1 == null && group2 == null) {
            EmailGroup group = (EmailGroup)groupDao.create("email", (Object)Sets.newHashSet((Object[])new Email[]{email1, email2}), new Object[0]);
            email1.setEmailGroup(group);
            email2.setEmailGroup(group);
        } else if (group1 == null) {
            email1.setEmailGroup(group2);
            group2.addEmail(email1);
            groupDao.update((TopiaEntity)group2);
        } else if (group2 == null) {
            email2.setEmailGroup(group1);
            group1.addEmail(email2);
            groupDao.update((TopiaEntity)group1);
        } else {
            if (group1.equals(group2)) {
                return email1;
            }
            group1.addAllEmail(group2.getEmail());
            email2.setEmailGroup(group1);
            group2.clearEmail();
            groupDao.delete(group2);
            groupDao.update((TopiaEntity)group1);
        }
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        Date now = new Date();
        History history = (History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "modificationDate", now});
        history.setFields((Set)Sets.newHashSet((Object[])new String[]{email2.getObject()}));
        email1.addHistory(history);
        Email result = (Email)emailDao.update((TopiaEntity)email1);
        History history2 = (History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "modificationDate", now});
        history2.setFields((Set)Sets.newHashSet((Object[])new String[]{email1.getObject()}));
        email2.addHistory(history2);
        emailDao.update((TopiaEntity)email2);
        this.getPersistenceContext().commit();
        return result;
    }

    @Override
    public Email reply(String from, String to, String cc, String bcc, String subject, String content, Collection<AttachmentFile> attachments, String originalEmailId, FaxToMailUser user) throws EmailException, MessagingException, IOException {
        Email email = this.getEmailById(originalEmailId, "history.faxToMailUser", "replies");
        String smtpUser = this.getApplicationConfig().getSmtpUser();
        String password = this.getApplicationConfig().getSmtpPassword();
        boolean useSsl = this.getApplicationConfig().isSmtpUseSsl();
        MultiPartEmail message = new MultiPartEmail();
        message.setHostName(this.getApplicationConfig().getSmtpHost());
        message.setSmtpPort(this.getApplicationConfig().getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && password != null) {
            message.setAuthenticator((Authenticator)new DefaultAuthenticator(smtpUser, password));
        }
        message.setSSLOnConnect(useSsl);
        message.setCharset("utf-8");
        message.setFrom(from);
        message.addTo(to);
        if (StringUtils.isNotBlank((CharSequence)cc)) {
            message.addCc(cc);
        }
        if (StringUtils.isNotBlank((CharSequence)bcc)) {
            message.addBcc(bcc);
        }
        message.setSubject(subject);
        message.setMsg(content);
        for (AttachmentFile attachmentFile : attachments) {
            File file = attachmentFile.getFile();
            FileDataSource source = new FileDataSource(file);
            message.attach((DataSource)source, attachmentFile.getFilename(), null);
        }
        message.send();
        ReplyTopiaDao replyTopiaDao = this.getPersistenceContext().getReplyDao();
        ReplyContentTopiaDao replyContentTopiaDao = this.getPersistenceContext().getReplyContentDao();
        Date now = new Date();
        StringBuilder emailHeaders = new StringBuilder();
        Enumeration headerLines = message.getMimeMessage().getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String headerLine = (String)headerLines.nextElement();
            emailHeaders.append(headerLine).append("\n");
        }
        emailHeaders.append("\n");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        IOUtils.write((CharSequence)emailHeaders, (OutputStream)byteOut);
        IOUtils.copy((InputStream)message.getMimeMessage().getInputStream(), (OutputStream)byteOut);
        ReplyContent replyContent = replyContentTopiaDao.createByNotNull(byteOut.toByteArray());
        Reply reply = (Reply)replyTopiaDao.create("replyContent", (Object)replyContent, new Object[]{"sentDate", now, "subject", subject, "sender", from, "recipient", to, "sentBy", user});
        email.addReplies(reply);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.REPLY, new Object[]{"faxToMailUser", user, "modificationDate", now});
        email.addHistory(history);
        email = this.saveEmail(email, user, new String[0]);
        return email;
    }

    @Override
    public void transmit(Collection<String> emailIds, MailFolder newFolder, FaxToMailUser currentUser) {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        List emails = dao.forTopiaIdIn(emailIds).findAll();
        for (Email email : emails) {
            email.setDemandStatus(DemandStatus.QUALIFIED);
            email.setMailFolder(newFolder);
            email.setTakenBy(null);
            History history = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION, new Object[]{"faxToMailUser", currentUser, "modificationDate", new Date()});
            email.addHistory(history);
        }
        dao.updateAll((Iterable)emails);
        this.getPersistenceContext().commit();
    }

    @Override
    public AttachmentFile getAttachmentFileFromStream(InputStream contentStream) {
        AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)contentStream, (OutputStream)output);
            attachmentFile.setContent(output.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't save content", ex);
        }
        return attachmentFile;
    }

    @Override
    public AttachmentFile getAttachmentFile(String attachmentId, boolean original) {
        AttachmentFile result;
        AttachmentTopiaDao dao = this.getPersistenceContext().getAttachmentDao();
        Attachment attachment = (Attachment)dao.forTopiaIdEquals(attachmentId).findUnique();
        AttachmentFile attachmentFile = result = original ? attachment.getOriginalFile() : attachment.getEditedFile();
        if (result != null) {
            Hibernate.initialize((Object)result);
        }
        return result;
    }

    @Override
    public ReplyContent getReplyContent(String replyId) {
        ReplyTopiaDao dao = this.getPersistenceContext().getReplyDao();
        Reply reply = (Reply)dao.forTopiaIdEquals(replyId).findUnique();
        ReplyContent result = reply.getReplyContent();
        Hibernate.initialize((Object)result);
        return result;
    }

    @Override
    public List<MailLock> getAllMailLocks() {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        List result = mailLockDao.findAll();
        return result;
    }

    @Override
    public void unlockMails(List<String> mailLockIds) {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        List mailLocks = mailLockDao.forTopiaIdIn(mailLockIds).findAll();
        mailLockDao.deleteAll((Iterable)mailLocks);
        this.getPersistenceContext().commit();
    }

    @Override
    public void rejectEmail(String from, String to, String subject, String content) throws EmailException, MessagingException, IOException {
        String smtpUser = this.getApplicationConfig().getSmtpUser();
        String password = this.getApplicationConfig().getSmtpPassword();
        boolean useSsl = this.getApplicationConfig().isSmtpUseSsl();
        MultiPartEmail message = new MultiPartEmail();
        message.setHostName(this.getApplicationConfig().getSmtpHost());
        message.setSmtpPort(this.getApplicationConfig().getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && password != null) {
            message.setAuthenticator((Authenticator)new DefaultAuthenticator(smtpUser, password));
        }
        message.setSSLOnConnect(useSsl);
        message.setCharset("utf-8");
        message.setFrom(from);
        message.addTo(to);
        message.setSubject(subject);
        message.setMsg(content);
        message.send();
    }

    @Override
    public void updateRangeRowsWithEdiReturns() {
        final RangeRowTopiaDao rangeRowTopiaDao = this.getPersistenceContext().getRangeRowDao();
        final EmailTopiaDao emailTopiaDao = this.getPersistenceContext().getEmailDao();
        final HashSet emailsToUpdate = new HashSet();
        TopiaSqlSupport sqlSupport = this.getPersistenceContext().getSqlSupport();
        sqlSupport.doSqlWork(new TopiaSqlWork(){

            public void execute(Connection connection) throws SQLException {
                int importedCount = 0;
                String query = String.format("SELECT %s, %s, %s FROM %s", "rangeRowTopiaId", "commandNumber", "error", EdiReturn.class.getSimpleName());
                Statement stat = connection.createStatement();
                ResultSet resultSet = stat.executeQuery(query);
                while (resultSet.next()) {
                    String rangeRowTopiaId = resultSet.getString("rangeRowTopiaId");
                    String commandNumber = resultSet.getString("commandNumber");
                    String error = resultSet.getString("error");
                    RangeRow rangeRow = (RangeRow)rangeRowTopiaDao.forTopiaIdEquals(rangeRowTopiaId).findUniqueOrNull();
                    if (rangeRow == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't find rangeRow " + rangeRowTopiaId + " to update"));
                        continue;
                    }
                    Email email = (Email)emailTopiaDao.forRangeRowContains(rangeRow).findUniqueOrNull();
                    if (email == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't find email for " + rangeRowTopiaId + " to update"));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        String oldError = email.getEdiError();
                        if (StringUtils.isNotBlank((CharSequence)oldError)) {
                            error = oldError + ", " + error;
                        }
                        email.setEdiError(error);
                    } else {
                        rangeRow.setCommandNumber(commandNumber);
                        rangeRowTopiaDao.update((TopiaEntity)rangeRow);
                    }
                    email.setDemandStatus(DemandStatus.IN_PROGRESS);
                    emailsToUpdate.add(email);
                    ++importedCount;
                }
                stat = connection.createStatement();
                stat.execute("DELETE FROM " + EdiReturn.class.getSimpleName());
                if (importedCount > 0 && log.isInfoEnabled()) {
                    log.info((Object)String.format("Imported %d ediReturn rows", importedCount));
                }
            }
        });
        emailTopiaDao.updateAll(emailsToUpdate);
        this.getPersistenceContext().commit();
    }

    @Override
    public AttachmentFile getEmailDetailAsAttachment(Email email) {
        AttachmentFileImpl result;
        block2: {
            result = null;
            try {
                String content = this.getEmailDetailAsHtml(email);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocumentFromString(content);
                renderer.layout();
                renderer.createPDF((OutputStream)out);
                result = new AttachmentFileImpl();
                result.setContent(out.toByteArray());
                result.setFilename(I18n.t((String)"faxtomail.attachment.demand.filename", (Object[])new Object[0]) + ".pdf");
                result.getFile();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    protected String getEmailDetailAsHtml(Email email) {
        Decorator<FaxToMailUser> userDecorator = this.getDecoratorService().getDecoratorByType(FaxToMailUser.class);
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        String result = email.getObject();
        String ref = email.getReference();
        if (!ref.isEmpty()) {
            result = ref + " - " + result;
        }
        scopes.put("title", result);
        scopes.put("receivedDate", DateFormatUtils.format((Date)email.getReceptionDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("sender", email.getSender());
        scopes.put("object", email.getObject());
        scopes.put("client", email.getClient());
        scopes.put("demandType", email.getDemandType());
        scopes.put("priority", email.getPriority());
        scopes.put("projectReference", email.getProjectReference());
        scopes.put("companyReference", email.getCompanyReference());
        scopes.put("waitingState", email.getWaitingState());
        scopes.put("status", email.getDemandStatus());
        scopes.put("takenBy", email.getTakenBy() == null ? "" : userDecorator.toString((Object)email.getTakenBy()));
        scopes.put("message", email.getComment());
        scopes.put("date", DateFormatUtils.format((Date)this.serviceContext.getNow(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("firstOpeningUser", email.getFirstOpeningUser() == null ? "" : userDecorator.toString((Object)email.getFirstOpeningUser()));
        scopes.put("firstOpeningDate", email.getFirstOpeningDate() == null ? "" : DateFormatUtils.format((Date)email.getFirstOpeningDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("lastModificationUser", email.getLastModificationUser() == null ? "" : userDecorator.toString((Object)email.getLastModificationUser()));
        scopes.put("lastModificationDate", email.getLastModificationDate() == null ? "" : DateFormatUtils.format((Date)email.getLastModificationDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("lastAttachmentOpeningInFolderUser", email.getLastAttachmentOpeningInFolderUser() == null ? "" : userDecorator.toString((Object)email.getLastAttachmentOpeningInFolderUser()));
        scopes.put("lastAttachmentOpeningInFolderDate", email.getLastAttachmentOpeningInFolderDate() == null ? "" : DateFormatUtils.format((Date)email.getLastAttachmentOpeningInFolderDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("hasRangeRows", email.sizeRangeRow() > 0);
        scopes.put("rangeRows", email.getRangeRow());
        InputStream is = EmailServiceImpl.class.getResourceAsStream("/pdf/demande.mustache");
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), "demande");
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, scopes);
        writer.flush();
        return writer.toString();
    }

    protected String getFullMailFolderPath(MailFolder folder) {
        StringBuilder sb = new StringBuilder(folder.getName());
        for (MailFolder loopFolder = folder.getParent(); loopFolder != null; loopFolder = loopFolder.getParent()) {
            sb.insert(0, "/");
            sb.insert(0, loopFolder.getName());
        }
        return sb.toString();
    }

    @Override
    public void importArchive(InputStream inputStream, File attachmentBase) {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        DemandTypeTopiaDao demandTypedao = this.getPersistenceContext().getDemandTypeDao();
        PriorityTopiaDao priorityDao = this.getPersistenceContext().getPriorityDao();
        WaitingStateTopiaDao waitingStateDao = this.getPersistenceContext().getWaitingStateDao();
        MailFolderTopiaDao mailFolderDao = this.getPersistenceContext().getMailFolderDao();
        AttachmentTopiaDao attachmentDao = this.getPersistenceContext().getAttachmentDao();
        AttachmentFileTopiaDao attachmentFileDao = this.getPersistenceContext().getAttachmentFileDao();
        ImmutableMap allDemandTypes = Maps.uniqueIndex((Iterable)demandTypedao, (Function)new Function<DemandType, String>(){

            public String apply(DemandType input) {
                return input.getLabel();
            }
        });
        ImmutableMap allPriority = Maps.uniqueIndex((Iterable)priorityDao, (Function)new Function<Priority, String>(){

            public String apply(Priority input) {
                return input.getLabel();
            }
        });
        ImmutableMap allWaitingStates = Maps.uniqueIndex((Iterable)waitingStateDao, (Function)new Function<WaitingState, String>(){

            public String apply(WaitingState input) {
                return input.getLabel();
            }
        });
        ImmutableMap mailFolderMap = Maps.uniqueIndex((Iterable)mailFolderDao, (Function)new Function<MailFolder, String>(){

            public String apply(MailFolder input) {
                return EmailServiceImpl.this.getFullMailFolderPath(input);
            }
        });
        ArchiveImportModel archiveImportModel = new ArchiveImportModel(';', (Map<String, WaitingState>)allWaitingStates, (Map<String, DemandType>)allDemandTypes, (Map<String, Priority>)allPriority, (Map<String, MailFolder>)mailFolderMap);
        Binder emailBinder = BinderFactory.newBinder(ArchiveImportBean.class, Email.class);
        Import importer = null;
        try {
            importer = Import.newImport((ImportModel)archiveImportModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));
            for (ArchiveImportBean archiveBean : importer) {
                Email email = (Email)emailDao.newInstance();
                emailBinder.copy((Object)archiveBean, (Object)email, new String[0]);
                email.setDemandStatus(DemandStatus.ARCHIVED);
                email = (Email)emailDao.create((TopiaEntity)email);
                if (archiveBean.getAttachmentPaths() == null) continue;
                Iterable itAttachmentPaths = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)archiveBean.getAttachmentPaths());
                for (String attachmentPath : itAttachmentPaths) {
                    File attFile = attachmentBase != null ? new File(attachmentBase, attachmentPath) : new File(attachmentPath);
                    if (!attFile.isFile()) {
                        throw new RuntimeException("Missing file " + attFile.getAbsolutePath());
                    }
                    AttachmentImpl attachment = new AttachmentImpl();
                    AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
                    attachmentFile.setFilename(attFile.getName());
                    attachmentFile.setContent(FileUtils.readFileToByteArray((File)attFile));
                    attachmentFile = (AttachmentFile)attachmentFileDao.create((TopiaEntity)attachmentFile);
                    attachment.setOriginalFile((AttachmentFile)attachmentFile);
                    attachment = (Attachment)attachmentDao.create((TopiaEntity)attachment);
                    email.addAttachment((Attachment)attachment);
                }
                emailDao.update((TopiaEntity)email);
            }
            this.getPersistenceContext().commit();
        }
        catch (IOException | ImportRuntimeException e) {
            try {
                String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                throw new ApplicationTechnicalException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Override
    public long getArchivedMailCount() {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        long result = emailDao.forDemandStatusEquals(DemandStatus.ARCHIVED).count();
        return result;
    }
}

