/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class ImageMetadataReader {
    private static final int JPEG_FILE_MAGIC_NUMBER = 65496;
    private static final int MOTOROLLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public static Metadata readMetadata(BufferedInputStream bufferedInputStream) throws ImageProcessingException {
        int n = ImageMetadataReader.readMagicNumber(bufferedInputStream);
        return ImageMetadataReader.readMetadata(bufferedInputStream, null, n);
    }

    public static Metadata readMetadata(File file) throws ImageProcessingException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageProcessingException("File not found: " + file.getPath(), fileNotFoundException);
        }
        int n = ImageMetadataReader.readMagicNumber(bufferedInputStream);
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new ImageProcessingException("Error closing file: " + file.getPath(), iOException);
        }
        return ImageMetadataReader.readMetadata(null, file, n);
    }

    private static Metadata readMetadata(BufferedInputStream bufferedInputStream, File file, int n) throws ImageProcessingException {
        if ((n & 0xFFD8) == 65496) {
            if (bufferedInputStream != null) {
                return JpegMetadataReader.readMetadata(bufferedInputStream);
            }
            return JpegMetadataReader.readMetadata(file);
        }
        if (n == 18761 || n == 19789) {
            if (bufferedInputStream != null) {
                return TiffMetadataReader.readMetadata(bufferedInputStream);
            }
            return TiffMetadataReader.readMetadata(file);
        }
        throw new ImageProcessingException("File is not the correct format");
    }

    private static int readMagicNumber(BufferedInputStream bufferedInputStream) throws ImageProcessingException {
        try {
            bufferedInputStream.mark(2);
            int n = bufferedInputStream.read() << 8;
            bufferedInputStream.reset();
        }
        catch (IOException iOException) {
            throw new ImageProcessingException("Error reading image data", iOException);
        }
        return n |= bufferedInputStream.read();
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(String[] stringArray) throws MetadataException, IOException {
        Directory directory;
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("Usage: java -jar metadata-extractor-a.b.c.jar <filename> [/thumb]");
            System.exit(1);
        }
        Metadata metadata = null;
        try {
            metadata = ImageMetadataReader.readMetadata(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        Iterator iterator = metadata.getDirectoryIterator();
        while (iterator.hasNext()) {
            Object object;
            directory = (Directory)iterator.next();
            Iterator iterator2 = directory.getTagIterator();
            while (iterator2.hasNext()) {
                object = (Tag)iterator2.next();
                try {
                    System.out.println("[" + directory.getName() + "] " + ((Tag)object).getTagName() + " = " + ((Tag)object).getDescription());
                }
                catch (MetadataException metadataException) {
                    System.err.println(metadataException.getMessage());
                    System.err.println(((Tag)object).getDirectoryName() + " " + ((Tag)object).getTagName() + " (error)");
                }
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
        if (stringArray.length > 1 && stringArray[1].trim().equals("/thumb")) {
            directory = (ExifDirectory)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ImageMetadataReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
            if (((ExifDirectory)directory).containsThumbnail()) {
                System.out.println("Writing thumbnail...");
                ((ExifDirectory)directory).writeThumbnail(stringArray[0].trim() + ".thumb.jpg");
            } else {
                System.out.println("No thumbnail data exists in this image");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

