/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="The progress information for a workflow instance")
public class ProgressInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="completedSteps")
    private BigDecimal completedSteps = null;
    @JsonProperty(value="currentCompletedStepName")
    private String currentCompletedStepName = null;
    @JsonProperty(value="totalSteps")
    private BigDecimal totalSteps = null;

    public ProgressInstance completedSteps(BigDecimal completedSteps) {
        this.completedSteps = completedSteps;
        return this;
    }

    @Schema(description="The number of completed steps for this workflow instance")
    public BigDecimal getCompletedSteps() {
        return this.completedSteps;
    }

    public void setCompletedSteps(BigDecimal completedSteps) {
        this.completedSteps = completedSteps;
    }

    public ProgressInstance currentCompletedStepName(String currentCompletedStepName) {
        this.currentCompletedStepName = currentCompletedStepName;
        return this;
    }

    @Schema(description="The last completed step name")
    public String getCurrentCompletedStepName() {
        return this.currentCompletedStepName;
    }

    public void setCurrentCompletedStepName(String currentCompletedStepName) {
        this.currentCompletedStepName = currentCompletedStepName;
    }

    public ProgressInstance totalSteps(BigDecimal totalSteps) {
        this.totalSteps = totalSteps;
        return this;
    }

    @Schema(description="The total number of steps for this workflow instance")
    public BigDecimal getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(BigDecimal totalSteps) {
        this.totalSteps = totalSteps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgressInstance progressInstance = (ProgressInstance)o;
        return Objects.equals(this.completedSteps, progressInstance.completedSteps) && Objects.equals(this.currentCompletedStepName, progressInstance.currentCompletedStepName) && Objects.equals(this.totalSteps, progressInstance.totalSteps);
    }

    public int hashCode() {
        return Objects.hash(this.completedSteps, this.currentCompletedStepName, this.totalSteps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProgressInstance {\n");
        sb.append("    completedSteps: ").append(this.toIndentedString(this.completedSteps)).append("\n");
        sb.append("    currentCompletedStepName: ").append(this.toIndentedString(this.currentCompletedStepName)).append("\n");
        sb.append("    totalSteps: ").append(this.toIndentedString(this.totalSteps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

