/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.api;

import com.docusign.maestro.client.ApiClient;
import com.docusign.maestro.client.ApiException;
import com.docusign.maestro.client.ApiResponse;
import com.docusign.maestro.client.Configuration;
import com.docusign.maestro.client.Pair;
import com.docusign.maestro.model.CancelResponse;
import com.docusign.maestro.model.WorkflowInstance;
import com.docusign.maestro.model.WorkflowStepHistory;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WorkflowInstanceManagementApi {
    private ApiClient apiClient;

    public WorkflowInstanceManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowInstanceManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CancelResponse cancelWorkflowInstance(String accountId, String instanceId) throws ApiException {
        ApiResponse<CancelResponse> localVarResponse = this.cancelWorkflowInstanceWithHttpInfo(accountId, instanceId);
        return localVarResponse.getData();
    }

    public ApiResponse<CancelResponse> cancelWorkflowInstanceWithHttpInfo(String accountId, String instanceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling cancelWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling cancelWorkflowInstance");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/instances/{instanceId}/cancel".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CancelResponse> localVarReturnType = new GenericType<CancelResponse>(){};
        CancelResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CancelResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public List<WorkflowStepHistory> getWorkflowHistory(String accountId, String instanceId) throws ApiException {
        ApiResponse<List<WorkflowStepHistory>> localVarResponse = this.getWorkflowHistoryWithHttpInfo(accountId, instanceId);
        return localVarResponse.getData();
    }

    public ApiResponse<List<WorkflowStepHistory>> getWorkflowHistoryWithHttpInfo(String accountId, String instanceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowHistory");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowHistory");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/instances/{instanceId}/history".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<List<WorkflowStepHistory>> localVarReturnType = new GenericType<List<WorkflowStepHistory>>(){};
        List<WorkflowStepHistory> localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<List<WorkflowStepHistory>>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowInstance getWorkflowInstance(String accountId, String workflowDefinitionId, String instanceId) throws ApiException {
        ApiResponse<WorkflowInstance> localVarResponse = this.getWorkflowInstanceWithHttpInfo(accountId, workflowDefinitionId, instanceId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowInstance> getWorkflowInstanceWithHttpInfo(String accountId, String workflowDefinitionId, String instanceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowInstance");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling getWorkflowInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling getWorkflowInstance");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}/instances/{instanceId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowInstance> localVarReturnType = new GenericType<WorkflowInstance>(){};
        WorkflowInstance localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowInstance>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public List<WorkflowInstance> getWorkflowInstances(String accountId, String workflowDefinitionId) throws ApiException {
        ApiResponse<List<WorkflowInstance>> localVarResponse = this.getWorkflowInstancesWithHttpInfo(accountId, workflowDefinitionId);
        return localVarResponse.getData();
    }

    public ApiResponse<List<WorkflowInstance>> getWorkflowInstancesWithHttpInfo(String accountId, String workflowDefinitionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowInstances");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling getWorkflowInstances");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}/instances".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<List<WorkflowInstance>> localVarReturnType = new GenericType<List<WorkflowInstance>>(){};
        List<WorkflowInstance> localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<List<WorkflowInstance>>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }
}

