/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.NameValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OauthAccess
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="access_token")
    private String accessToken = null;
    @JsonProperty(value="data")
    private List<NameValue> data = null;
    @JsonProperty(value="expires_in")
    private String expiresIn = null;
    @JsonProperty(value="refresh_token")
    private String refreshToken = null;
    @JsonProperty(value="scope")
    private String scope = null;
    @JsonProperty(value="token_type")
    private String tokenType = null;

    public OauthAccess accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Schema(description="Access token information.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OauthAccess data(List<NameValue> data) {
        this.data = data;
        return this;
    }

    public OauthAccess addDataItem(NameValue dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<NameValue>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Schema(description="")
    public List<NameValue> getData() {
        return this.data;
    }

    public void setData(List<NameValue> data) {
        this.data = data;
    }

    public OauthAccess expiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Schema(description="")
    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OauthAccess refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Schema(description="")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OauthAccess scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Schema(description="Must be set to \"api\".")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OauthAccess tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Schema(description="")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthAccess oauthAccess = (OauthAccess)o;
        return Objects.equals(this.accessToken, oauthAccess.accessToken) && Objects.equals(this.data, oauthAccess.data) && Objects.equals(this.expiresIn, oauthAccess.expiresIn) && Objects.equals(this.refreshToken, oauthAccess.refreshToken) && Objects.equals(this.scope, oauthAccess.scope) && Objects.equals(this.tokenType, oauthAccess.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.data, this.expiresIn, this.refreshToken, this.scope, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OauthAccess {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

