/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigNestedIntArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitVector;

public class MultiValueORFacetFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    private final FacetHandler<?> _facetHandler;
    private final String[] _vals;
    private final boolean _takeCompliment;
    private final FacetValueConverter _valueConverter;

    public MultiValueORFacetFilter(FacetHandler<?> facetHandler, String[] vals, boolean takeCompliment) {
        this(facetHandler, vals, FacetValueConverter.DEFAULT, takeCompliment);
    }

    public MultiValueORFacetFilter(FacetHandler<?> facetHandler, String[] vals, FacetValueConverter valueConverter, boolean takeCompliment) {
        this._facetHandler = facetHandler;
        this._vals = vals;
        this._valueConverter = valueConverter;
        this._takeCompliment = takeCompliment;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = 0.0;
        MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this._facetHandler.getFacetData(reader);
        int[] idxes = this._valueConverter.convert(dataCache, this._vals);
        if (idxes == null) {
            return 0.0;
        }
        int accumFreq = 0;
        for (int idx : idxes) {
            accumFreq += dataCache.freqs[idx];
        }
        int total = reader.maxDoc();
        selectivity = (double)accumFreq / (double)total;
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        int count;
        final MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this._facetHandler.getFacetData(reader);
        int[] index = this._valueConverter.convert(dataCache, this._vals);
        final BigNestedIntArray nestedArray = dataCache._nestedArray;
        final BitVector bitset = new BitVector(dataCache.valArray.size());
        for (int i : index) {
            bitset.set(i);
        }
        if (this._takeCompliment) {
            int size = bitset.size();
            for (int i = 0; i < size; ++i) {
                if (bitset.get(i)) {
                    bitset.clear(i);
                    continue;
                }
                bitset.set(i);
            }
        }
        if ((count = bitset.count()) == 0) {
            final EmptyDocIdSet empty = EmptyDocIdSet.getInstance();
            return new RandomAccessDocIdSet(){

                @Override
                public boolean get(int docId) {
                    return false;
                }

                public DocIdSetIterator iterator() throws IOException {
                    return empty.iterator();
                }
            };
        }
        return new RandomAccessDocIdSet(){

            public DocIdSetIterator iterator() {
                return new MultiValueOrFacetDocIdSetIterator(dataCache, bitset);
            }

            @Override
            public final boolean get(int docId) {
                return nestedArray.contains(docId, bitset);
            }
        };
    }

    private static final class MultiValueOrFacetDocIdSetIterator
    extends FacetOrFilter.FacetOrDocIdSetIterator {
        private final BigNestedIntArray _nestedArray;

        public MultiValueOrFacetDocIdSetIterator(MultiValueFacetDataCache dataCache, BitVector bs) {
            super(dataCache, bs);
            this._nestedArray = dataCache._nestedArray;
        }

        @Override
        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._nestedArray.findValues(this._bitset, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        @Override
        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._nestedArray.findValues(this._bitset, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }
    }
}

