/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.sort.DocComparator;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;

public abstract class DocComparatorSource {
    boolean _reverse = false;

    public void setReverse(boolean reverse) {
        this._reverse = reverse;
    }

    public final boolean isReverse() {
        return this._reverse;
    }

    public abstract DocComparator getComparator(IndexReader var1, int var2) throws IOException;

    public static class ByteDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public ByteDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final byte[] values = FieldCache.DEFAULT.getBytes(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values[doc1.doc] - values[doc2.doc];
                }

                @Override
                public Byte value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class DocIdDocComparatorSource
    extends DocComparatorSource {
        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final int _docbase = docbase;
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return doc1.doc - doc2.doc;
                }

                @Override
                public Integer value(ScoreDoc doc) {
                    return doc.doc + _docbase;
                }
            };
        }
    }

    public static class RelevanceDocComparatorSource
    extends DocComparatorSource {
        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (doc1.score < doc2.score) {
                        return -1;
                    }
                    if (doc1.score > doc2.score) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Float value(ScoreDoc doc) {
                    return Float.valueOf(doc.score);
                }
            };
        }
    }

    public static class DoubleDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public DoubleDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final double[] values = FieldCache.DEFAULT.getDoubles(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] < values[doc2.doc]) {
                        return -1;
                    }
                    if (values[doc1.doc] > values[doc2.doc]) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Double value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class FloatDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public FloatDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final float[] values = FieldCache.DEFAULT.getFloats(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] < values[doc2.doc]) {
                        return -1;
                    }
                    if (values[doc1.doc] > values[doc2.doc]) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Float value(ScoreDoc doc) {
                    return Float.valueOf(values[doc.doc]);
                }
            };
        }
    }

    public static class LongDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public LongDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final long[] values = FieldCache.DEFAULT.getLongs(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] < values[doc2.doc]) {
                        return -1;
                    }
                    if (values[doc1.doc] > values[doc2.doc]) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Long value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class ShortDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public ShortDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final short[] values = FieldCache.DEFAULT.getShorts(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values[doc1.doc] - values[doc2.doc];
                }

                @Override
                public Short value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class StringOrdComparatorSource
    extends DocComparatorSource {
        private final String field;

        public StringOrdComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final FieldCache.StringIndex values = FieldCache.DEFAULT.getStringIndex(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values.order[doc1.doc] - values.order[doc2.doc];
                }

                public String value(ScoreDoc doc) {
                    return String.valueOf(values.lookup[values.order[doc.doc]]);
                }
            };
        }
    }

    public static class StringValComparatorSource
    extends DocComparatorSource {
        private final String field;

        public StringValComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final String[] values = FieldCache.DEFAULT.getStrings(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] == null) {
                        if (values[doc2.doc] == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (values[doc2.doc] == null) {
                        return 1;
                    }
                    return values[doc1.doc].compareTo(values[doc2.doc]);
                }

                public String value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class StringLocaleComparatorSource
    extends DocComparatorSource {
        private final String field;
        private final Collator _collator;

        public StringLocaleComparatorSource(String field, Locale locale) {
            this.field = field;
            this._collator = Collator.getInstance(locale);
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final String[] values = FieldCache.DEFAULT.getStrings(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] == null) {
                        if (values[doc2.doc] == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (values[doc2.doc] == null) {
                        return 1;
                    }
                    return StringLocaleComparatorSource.this._collator.compare(values[doc1.doc], values[doc2.doc]);
                }

                public String value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }

    public static class IntDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public IntDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            final int[] values = FieldCache.DEFAULT.getInts(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values[doc1.doc] < values[doc2.doc]) {
                        return -1;
                    }
                    if (values[doc1.doc] > values[doc2.doc]) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Integer value(ScoreDoc doc) {
                    return values[doc.doc];
                }
            };
        }
    }
}

