/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxWebLink;
import com.box.sdk.JsonIterator;
import com.box.sdk.PagingParameters;
import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;

class BoxItemIterator
implements Iterator<BoxItem.Info> {
    private static final long LIMIT = 1000L;
    private final BoxAPIConnection api;
    private final JsonIterator iterator;

    BoxItemIterator(BoxAPIConnection api, URL url, PagingParameters pagingParameters) {
        this.api = api;
        this.iterator = new JsonIterator(api, url, pagingParameters);
        this.iterator.setFilter(jsonObject -> {
            String type = jsonObject.get("type").asString();
            return type.equals("file") || type.equals("folder") || type.equals("web_link");
        });
    }

    BoxItemIterator(BoxAPIConnection api, URL url) {
        this(api, url, PagingParameters.offset(0L, 1000L));
    }

    BoxItemIterator(BoxAPIConnection api, URL url, long limit, long offset) {
        this(api, url, PagingParameters.offset(offset, limit));
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public BoxItem.Info next() {
        BoxItem.Info nextItemInfo;
        JsonObject nextJSONObject = this.iterator.next();
        String type = nextJSONObject.get("type").asString();
        String id = nextJSONObject.get("id").asString();
        if (type.equals("folder")) {
            BoxFolder folder;
            BoxFolder boxFolder = folder = new BoxFolder(this.api, id);
            boxFolder.getClass();
            nextItemInfo = boxFolder.new BoxFolder.Info(nextJSONObject);
        } else if (type.equals("file")) {
            BoxFile file;
            BoxFile boxFile = file = new BoxFile(this.api, id);
            boxFile.getClass();
            nextItemInfo = boxFile.new BoxFile.Info(nextJSONObject);
        } else if (type.equals("web_link")) {
            BoxWebLink link;
            BoxWebLink boxWebLink = link = new BoxWebLink(this.api, id);
            boxWebLink.getClass();
            nextItemInfo = boxWebLink.new BoxWebLink.Info(nextJSONObject);
        } else {
            assert (false) : "Unsupported item type: " + type;
            throw new BoxAPIException("Unsupported item type: " + type);
        }
        return nextItemInfo;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

