/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.archives;

import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.archives.CreateArchiveV2025R0Headers;
import com.box.sdkgen.managers.archives.CreateArchiveV2025R0RequestBody;
import com.box.sdkgen.managers.archives.DeleteArchiveByIdV2025R0Headers;
import com.box.sdkgen.managers.archives.GetArchivesV2025R0Headers;
import com.box.sdkgen.managers.archives.GetArchivesV2025R0QueryParams;
import com.box.sdkgen.managers.archives.UpdateArchiveByIdV2025R0Headers;
import com.box.sdkgen.managers.archives.UpdateArchiveByIdV2025R0RequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.v2025r0.archivesv2025r0.ArchivesV2025R0;
import com.box.sdkgen.schemas.v2025r0.archivev2025r0.ArchiveV2025R0;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class ArchivesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public ArchivesManager() {
        this.networkSession = new NetworkSession();
    }

    protected ArchivesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public ArchivesV2025R0 getArchivesV2025R0() {
        return this.getArchivesV2025R0(new GetArchivesV2025R0QueryParams(), new GetArchivesV2025R0Headers());
    }

    public ArchivesV2025R0 getArchivesV2025R0(GetArchivesV2025R0QueryParams queryParams) {
        return this.getArchivesV2025R0(queryParams, new GetArchivesV2025R0Headers());
    }

    public ArchivesV2025R0 getArchivesV2025R0(GetArchivesV2025R0Headers headers) {
        return this.getArchivesV2025R0(new GetArchivesV2025R0QueryParams(), headers);
    }

    public ArchivesV2025R0 getArchivesV2025R0(GetArchivesV2025R0QueryParams queryParams, GetArchivesV2025R0Headers headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/archives"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ArchivesV2025R0.class);
    }

    public ArchiveV2025R0 createArchiveV2025R0(CreateArchiveV2025R0RequestBody requestBody) {
        return this.createArchiveV2025R0(requestBody, new CreateArchiveV2025R0Headers());
    }

    public ArchiveV2025R0 createArchiveV2025R0(CreateArchiveV2025R0RequestBody requestBody, CreateArchiveV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/archives"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ArchiveV2025R0.class);
    }

    public void deleteArchiveByIdV2025R0(String archiveId) {
        this.deleteArchiveByIdV2025R0(archiveId, new DeleteArchiveByIdV2025R0Headers());
    }

    public void deleteArchiveByIdV2025R0(String archiveId, DeleteArchiveByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/archives/", UtilsManager.convertToString(archiveId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public ArchiveV2025R0 updateArchiveByIdV2025R0(String archiveId) {
        return this.updateArchiveByIdV2025R0(archiveId, new UpdateArchiveByIdV2025R0RequestBody(), new UpdateArchiveByIdV2025R0Headers());
    }

    public ArchiveV2025R0 updateArchiveByIdV2025R0(String archiveId, UpdateArchiveByIdV2025R0RequestBody requestBody) {
        return this.updateArchiveByIdV2025R0(archiveId, requestBody, new UpdateArchiveByIdV2025R0Headers());
    }

    public ArchiveV2025R0 updateArchiveByIdV2025R0(String archiveId, UpdateArchiveByIdV2025R0Headers headers) {
        return this.updateArchiveByIdV2025R0(archiveId, new UpdateArchiveByIdV2025R0RequestBody(), headers);
    }

    public ArchiveV2025R0 updateArchiveByIdV2025R0(String archiveId, UpdateArchiveByIdV2025R0RequestBody requestBody, UpdateArchiveByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/archives/", UtilsManager.convertToString(archiveId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ArchiveV2025R0.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public ArchivesManager build() {
            return new ArchivesManager(this);
        }
    }
}

