/*
 * Decompiled with CFR 0.152.
 */
package com.bekioui.maven.plugin.merge;

import com.bekioui.maven.plugin.merge.Merge;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="merge", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class MergeMojo
extends AbstractMojo {
    private static Logger LOGGER = LoggerFactory.getLogger(MergeMojo.class);
    @Parameter(property="merges", required=true)
    private List<Merge> merges;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Merge merge : this.merges) {
            this.createTargetFile(merge);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(merge.getTarget(), true));
                Throwable throwable = null;
                try {
                    for (File file : this.getSources(merge)) {
                        if (file.isDirectory()) {
                            this.merge(this.checkSourceDirectory(file), writer);
                            continue;
                        }
                        this.merge(this.checkSourceFile(file), writer);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to write into target file", e);
            }
        }
    }

    private List<File> getSources(Merge merge) throws MojoExecutionException {
        if (merge.getSources() != null) {
            return merge.getSources();
        }
        if (merge.getPattern() != null) {
            if (!merge.getSearchDir().isDirectory()) {
                throw new MojoExecutionException("searchDir is not a directory: " + merge.getSearchDir().getAbsolutePath());
            }
            LOGGER.info("Search directory: {}", (Object)merge.getSearchDir());
            LOGGER.info("Pattern: {}", (Object)merge.getPattern());
            Pattern pattern = Pattern.compile(merge.getPattern());
            try {
                List<File> files = Files.walk(merge.getSearchDir().toPath(), new FileVisitOption[0]).map(Path::toFile).filter(file -> pattern.matcher(file.getName()).matches()).collect(Collectors.toList());
                System.out.println(files.stream().map(File::getName).collect(Collectors.toList()));
                LOGGER.info("Number of found files: {}", (Object)files.size());
                return files;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to find files with pattern.", (Exception)e);
            }
        }
        throw new MojoExecutionException("Failed to find files to merge, <sources> or <pattern> are not defined");
    }

    private void createTargetFile(Merge merge) throws MojoExecutionException {
        File file = merge.getTarget();
        if (file.isDirectory()) {
            throw new MojoExecutionException("Target file cannot be a directory: " + file.getAbsolutePath());
        }
        if (!merge.isOverride() && file.exists()) {
            throw new MojoExecutionException("Target file already exists: " + file.getAbsolutePath());
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new MojoExecutionException("Could not create target parent directory: " + parentFile.getAbsolutePath());
        }
        if (!parentFile.isDirectory()) {
            throw new MojoExecutionException("Target parent file is not a directory: " + parentFile.getAbsolutePath());
        }
        if (merge.isOverride()) {
            file.delete();
        }
        try {
            if (!file.createNewFile()) {
                throw new MojoExecutionException("Could not create target file: " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create target file: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private File checkSourceFile(File file) throws MojoExecutionException {
        if (!file.exists()) {
            throw new MojoExecutionException("Source file " + file.getAbsolutePath() + " does not exist.");
        }
        return file;
    }

    private List<File> checkSourceDirectory(File file) throws MojoExecutionException {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        this.checkSourceFile(file);
        Object[] files = file.listFiles();
        Arrays.sort(files);
        ArrayList<File> subFiles = new ArrayList<File>();
        for (Object subFile : files) {
            if (((File)subFile).isDirectory()) {
                sourceFiles.addAll(this.checkSourceDirectory((File)subFile));
                continue;
            }
            subFiles.add(this.checkSourceFile((File)subFile));
        }
        sourceFiles.addAll(subFiles);
        return sourceFiles;
    }

    private void merge(File file, BufferedWriter writer) throws MojoExecutionException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write source file " + file.getAbsolutePath(), e);
        }
    }

    private void merge(List<File> files, BufferedWriter writer) throws MojoExecutionException {
        for (File file : files) {
            this.merge(file, writer);
        }
    }
}

