/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public final class SecretUpdateParameters
implements JsonSerializable<SecretUpdateParameters> {
    private String secretContentType;
    private SecretAttributes secretAttributes;
    private Map<String, String> tags;

    public String getSecretContentType() {
        return this.secretContentType;
    }

    public SecretUpdateParameters setSecretContentType(String secretContentType) {
        this.secretContentType = secretContentType;
        return this;
    }

    public SecretAttributes getSecretAttributes() {
        return this.secretAttributes;
    }

    public SecretUpdateParameters setSecretAttributes(SecretAttributes secretAttributes) {
        this.secretAttributes = secretAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretUpdateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.secretContentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.secretAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecretUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecretUpdateParameters)jsonReader.readObject(reader -> {
            SecretUpdateParameters deserializedSecretUpdateParameters = new SecretUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedSecretUpdateParameters.secretContentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretUpdateParameters.secretAttributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretUpdateParameters;
        });
    }
}

