/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation.jackson.core.json;

import com.azure.json.implementation.jackson.core.JsonStreamContext;

public class JsonWriteContext
extends JsonStreamContext {
    public static final int STATUS_OK_AS_IS = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    protected final JsonWriteContext _parent;
    protected JsonWriteContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotName;

    protected JsonWriteContext(int type, JsonWriteContext parent) {
        this._type = type;
        this._parent = parent;
        this._index = -1;
    }

    public JsonWriteContext reset(int type) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        this._currentValue = null;
        return this;
    }

    public JsonWriteContext reset(int type, Object currValue) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        this._currentValue = currValue;
        return this;
    }

    public static JsonWriteContext createRootContext() {
        return new JsonWriteContext(0, null);
    }

    public JsonWriteContext createChildArrayContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonWriteContext(1, this);
            return ctxt;
        }
        return ctxt.reset(1);
    }

    public JsonWriteContext createChildObjectContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonWriteContext(2, this);
            return ctxt;
        }
        return ctxt.reset(2);
    }

    @Override
    public final JsonWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public JsonWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public int writeFieldName(String name) {
        if (this._type != 2 || this._gotName) {
            return 4;
        }
        this._gotName = true;
        this._currentName = name;
        return this._index < 0 ? 0 : 1;
    }

    public int writeValue() {
        if (this._type == 2) {
            if (!this._gotName) {
                return 5;
            }
            this._gotName = false;
            ++this._index;
            return 2;
        }
        if (this._type == 1) {
            int ix;
            return (ix = this._index++) < 0 ? 0 : 1;
        }
        ++this._index;
        return this._index == 0 ? 0 : 3;
    }
}

