/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.data.tables.models.TableServiceGeoReplicationStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceGeoReplication
implements XmlSerializable<TableServiceGeoReplication> {
    private TableServiceGeoReplicationStatus status;
    private DateTimeRfc1123 lastSyncTime;

    public TableServiceGeoReplication(TableServiceGeoReplicationStatus status, OffsetDateTime lastSyncTime) {
        this.status = status;
        this.lastSyncTime = lastSyncTime == null ? null : new DateTimeRfc1123(lastSyncTime);
    }

    public TableServiceGeoReplicationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getLastSyncTime() {
        if (this.lastSyncTime == null) {
            return null;
        }
        return this.lastSyncTime.getDateTime();
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "GeoReplication" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement("LastSyncTime", Objects.toString(this.lastSyncTime, null));
        return xmlWriter.writeEndElement();
    }

    public static TableServiceGeoReplication fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceGeoReplication.fromXml(xmlReader, null);
    }

    public static TableServiceGeoReplication fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "GeoReplication" : rootElementName;
        return (TableServiceGeoReplication)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceGeoReplication deserializedTableServiceGeoReplication = new TableServiceGeoReplication();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Status".equals(elementName.getLocalPart())) {
                    deserializedTableServiceGeoReplication.status = TableServiceGeoReplicationStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("LastSyncTime".equals(elementName.getLocalPart())) {
                    deserializedTableServiceGeoReplication.lastSyncTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceGeoReplication;
        });
    }

    private TableServiceGeoReplication() {
    }
}

