// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.data.tables.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The TableServiceGeoReplication model.
 */
@Immutable
public final class TableServiceGeoReplication implements XmlSerializable<TableServiceGeoReplication> {

    /*
     * The status of the secondary location.
     */
    private TableServiceGeoReplicationStatus status;

    /*
     * A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for
     * read operations at the secondary. Primary writes after this point in time may or may not be available for reads.
     */
    private DateTimeRfc1123 lastSyncTime;

    /**
     * Creates an instance of TableServiceGeoReplication class.
     *
     * @param status The status of the secondary location.
     * @param lastSyncTime A GMT date/time value, to the second. All primary writes preceding this value are guaranteed
     * to be available for read operations at the secondary. Primary writes after this point in time may or may not
     * be available for reads.
     */
    public TableServiceGeoReplication(TableServiceGeoReplicationStatus status, OffsetDateTime lastSyncTime) {
        this.status = status;
        this.lastSyncTime = (lastSyncTime == null) ? null : new DateTimeRfc1123(lastSyncTime);
    }

    /**
     * Get the status property: The status of the secondary location.
     *
     * @return the status value.
     */
    public TableServiceGeoReplicationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the lastSyncTime property: A GMT date/time value, to the second. All primary writes preceding this value are
     * guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or
     * may not be available for reads.
     *
     * @return the lastSyncTime value.
     */
    public OffsetDateTime getLastSyncTime() {
        if (this.lastSyncTime == null) {
            return null;
        }
        return this.lastSyncTime.getDateTime();
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "GeoReplication" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement("LastSyncTime", Objects.toString(this.lastSyncTime, null));
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableServiceGeoReplication from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableServiceGeoReplication if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceGeoReplication.
     */
    public static TableServiceGeoReplication fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableServiceGeoReplication from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableServiceGeoReplication if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceGeoReplication.
     */
    public static TableServiceGeoReplication fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "GeoReplication" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceGeoReplication deserializedTableServiceGeoReplication = new TableServiceGeoReplication();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Status".equals(elementName.getLocalPart())) {
                    deserializedTableServiceGeoReplication.status
                        = TableServiceGeoReplicationStatus.fromString(reader.getStringElement());
                } else if ("LastSyncTime".equals(elementName.getLocalPart())) {
                    deserializedTableServiceGeoReplication.lastSyncTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else {
                    reader.skipElement();
                }
            }
            return deserializedTableServiceGeoReplication;
        });
    }

    private TableServiceGeoReplication() {
    }
}
