/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.local.LocalFullRevisionPkgInfo;
import com.android.sdklib.local.LocalSdk;
import com.android.sdklib.repository.NoPreviewRevision;
import java.io.File;
import java.util.Properties;

public class LocalExtraPkgInfo
extends LocalFullRevisionPkgInfo {
    @NonNull
    private final String mExtraPath;
    @NonNull
    private final String mVendorId;

    public LocalExtraPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull String vendorId, @NonNull String path, @NonNull NoPreviewRevision revision) {
        super(localSdk, localDir, sourceProps, revision);
        this.mVendorId = vendorId;
        this.mExtraPath = path;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean hasPath() {
        return true;
    }

    @NonNull
    public String getExtraPath() {
        return this.mExtraPath;
    }

    @NonNull
    public String getVendorId() {
        return this.mVendorId;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.mVendorId + '/' + this.mExtraPath;
    }

    @Override
    @Nullable
    public Package getPackage() {
        Package pkg = super.getPackage();
        if (pkg == null) {
            try {
                pkg = ExtraPackage.create(null, this.getSourceProperties(), this.mVendorId, this.mExtraPath, 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), this.getLocalDir().getPath());
                this.setPackage(pkg);
            }
            catch (Exception e) {
                this.appendLoadError("Failed to parse package: %1$s", e.toString());
            }
        }
        return pkg;
    }
}

