/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.model.ClassField;
import java.io.Serializable;

public final class ClassFieldImpl
implements ClassField,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String type;
    @NonNull
    private final String name;
    @NonNull
    private final String value;

    public ClassFieldImpl(@NonNull String type, @NonNull String name, @NonNull String value) {
        if (type == null || name == null || value == null) {
            throw new NullPointerException("Build Config field cannot have a null parameter");
        }
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassFieldImpl that = (ClassFieldImpl)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

