/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.spy.memcached.compat.log.DefaultLogger;
import net.spy.memcached.compat.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    private static LoggerFactory instance = null;
    private final ConcurrentMap<String, Logger> instances = new ConcurrentHashMap<String, Logger>();
    private Constructor<? extends Logger> instanceConstructor;

    private LoggerFactory() {
    }

    private static void init() {
        if (instance == null) {
            instance = new LoggerFactory();
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        if (name == null) {
            throw new NullPointerException("Logger name may not be null.");
        }
        LoggerFactory.init();
        return instance.internalGetLogger(name);
    }

    private Logger internalGetLogger(String name) {
        assert (name != null) : "Name was null";
        Logger rv = (Logger)this.instances.get(name);
        if (rv == null) {
            Logger newLogger = null;
            try {
                newLogger = this.getNewInstance(name);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem getting logger", e);
            }
            Logger tmp = this.instances.putIfAbsent(name, newLogger);
            rv = tmp == null ? newLogger : tmp;
        }
        return rv;
    }

    private Logger getNewInstance(String name) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.instanceConstructor == null) {
            this.getConstructor();
        }
        Object[] args = new Object[]{name};
        Logger rv = this.instanceConstructor.newInstance(args);
        return rv;
    }

    private void getConstructor() {
        Class c = DefaultLogger.class;
        String className = System.getProperty("net.spy.log.LoggerImpl");
        if (className != null) {
            try {
                c = Class.forName(className);
            }
            catch (NoClassDefFoundError e) {
                System.err.println("Warning:  " + className + " not found while initializing" + " net.spy.compat.log.LoggerFactory");
                e.printStackTrace();
                c = DefaultLogger.class;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning:  " + className + " not found while initializing" + " net.spy.compat.log.LoggerFactory");
                e.printStackTrace();
                c = DefaultLogger.class;
            }
        }
        try {
            Class[] args = new Class[]{String.class};
            this.instanceConstructor = c.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            try {
                Class[] args = new Class[]{};
                this.instanceConstructor = c.getConstructor(args);
            }
            catch (NoSuchMethodException e2) {
                System.err.println("Warning:  " + className + " has no appropriate constructor, using defaults.");
                try {
                    Class[] args = new Class[]{String.class};
                    this.instanceConstructor = DefaultLogger.class.getConstructor(args);
                }
                catch (NoSuchMethodException e3) {
                    throw new NoSuchMethodError("There used to be a constructor that takes a single String on " + DefaultLogger.class + ", but I " + "can't find one now.");
                }
            }
        }
    }
}

