/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wafv2.model;

import javax.annotation.Generated;

/**
 * <p>
 * The rule that you've named doesn't aggregate solely on the IP address or solely on the forwarded IP address. This
 * call is only available for rate-based rules with an <code>AggregateKeyType</code> setting of <code>IP</code> or
 * <code>FORWARDED_IP</code>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WAFUnsupportedAggregateKeyTypeException extends com.amazonaws.services.wafv2.model.AWSWAFV2Exception {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new WAFUnsupportedAggregateKeyTypeException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public WAFUnsupportedAggregateKeyTypeException(String message) {
        super(message);
    }

}
