/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.Block;
import com.amazonaws.services.textract.model.DocumentMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectDocumentTextResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private DocumentMetadata documentMetadata;
    private List<Block> blocks;
    private String detectDocumentTextModelVersion;

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public DetectDocumentTextResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Collection<Block> blocks) {
        if (blocks == null) {
            this.blocks = null;
            return;
        }
        this.blocks = new ArrayList<Block>(blocks);
    }

    public DetectDocumentTextResult withBlocks(Block ... blocks) {
        if (this.blocks == null) {
            this.setBlocks(new ArrayList<Block>(blocks.length));
        }
        for (Block ele : blocks) {
            this.blocks.add(ele);
        }
        return this;
    }

    public DetectDocumentTextResult withBlocks(Collection<Block> blocks) {
        this.setBlocks(blocks);
        return this;
    }

    public void setDetectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
        this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
    }

    public String getDetectDocumentTextModelVersion() {
        return this.detectDocumentTextModelVersion;
    }

    public DetectDocumentTextResult withDetectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
        this.setDetectDocumentTextModelVersion(detectDocumentTextModelVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getBlocks() != null) {
            sb.append("Blocks: ").append(this.getBlocks()).append(",");
        }
        if (this.getDetectDocumentTextModelVersion() != null) {
            sb.append("DetectDocumentTextModelVersion: ").append(this.getDetectDocumentTextModelVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDocumentTextResult)) {
            return false;
        }
        DetectDocumentTextResult other = (DetectDocumentTextResult)obj;
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getBlocks() == null ^ this.getBlocks() == null) {
            return false;
        }
        if (other.getBlocks() != null && !other.getBlocks().equals(this.getBlocks())) {
            return false;
        }
        if (other.getDetectDocumentTextModelVersion() == null ^ this.getDetectDocumentTextModelVersion() == null) {
            return false;
        }
        return other.getDetectDocumentTextModelVersion() == null || other.getDetectDocumentTextModelVersion().equals(this.getDetectDocumentTextModelVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getBlocks() == null ? 0 : this.getBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getDetectDocumentTextModelVersion() == null ? 0 : this.getDetectDocumentTextModelVersion().hashCode());
        return hashCode;
    }

    public DetectDocumentTextResult clone() {
        try {
            return (DetectDocumentTextResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

