/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.DatabaseType;
import com.amazonaws.services.ssmsap.model.transform.DatabaseSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DatabaseSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String componentId;
    private String databaseId;
    private String databaseType;
    private String arn;
    private Map<String, String> tags;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public DatabaseSummary withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public DatabaseSummary withComponentId(String componentId) {
        this.setComponentId(componentId);
        return this;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public DatabaseSummary withDatabaseId(String databaseId) {
        this.setDatabaseId(databaseId);
        return this;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSummary withDatabaseType(String databaseType) {
        this.setDatabaseType(databaseType);
        return this;
    }

    public DatabaseSummary withDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DatabaseSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public DatabaseSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public DatabaseSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public DatabaseSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getComponentId() != null) {
            sb.append("ComponentId: ").append(this.getComponentId()).append(",");
        }
        if (this.getDatabaseId() != null) {
            sb.append("DatabaseId: ").append(this.getDatabaseId()).append(",");
        }
        if (this.getDatabaseType() != null) {
            sb.append("DatabaseType: ").append(this.getDatabaseType()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseSummary)) {
            return false;
        }
        DatabaseSummary other = (DatabaseSummary)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getComponentId() == null ^ this.getComponentId() == null) {
            return false;
        }
        if (other.getComponentId() != null && !other.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (other.getDatabaseId() == null ^ this.getDatabaseId() == null) {
            return false;
        }
        if (other.getDatabaseId() != null && !other.getDatabaseId().equals(this.getDatabaseId())) {
            return false;
        }
        if (other.getDatabaseType() == null ^ this.getDatabaseType() == null) {
            return false;
        }
        if (other.getDatabaseType() != null && !other.getDatabaseType().equals(this.getDatabaseType())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentId() == null ? 0 : this.getComponentId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseId() == null ? 0 : this.getDatabaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseType() == null ? 0 : this.getDatabaseType().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DatabaseSummary clone() {
        try {
            return (DatabaseSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatabaseSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

