/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.MetadataProvider;
import com.amazonaws.services.sagemakergeospatial.model.transform.S3DataInputMarshaller;
import java.io.Serializable;

public class S3DataInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String kmsKeyId;
    private String metadataProvider;
    private String s3Uri;

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public S3DataInput withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setMetadataProvider(String metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public String getMetadataProvider() {
        return this.metadataProvider;
    }

    public S3DataInput withMetadataProvider(String metadataProvider) {
        this.setMetadataProvider(metadataProvider);
        return this;
    }

    public S3DataInput withMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider.toString();
        return this;
    }

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public S3DataInput withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getMetadataProvider() != null) {
            sb.append("MetadataProvider: ").append(this.getMetadataProvider()).append(",");
        }
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataInput)) {
            return false;
        }
        S3DataInput other = (S3DataInput)obj;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getMetadataProvider() == null ^ this.getMetadataProvider() == null) {
            return false;
        }
        if (other.getMetadataProvider() != null && !other.getMetadataProvider().equals(this.getMetadataProvider())) {
            return false;
        }
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        return other.getS3Uri() == null || other.getS3Uri().equals(this.getS3Uri());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getMetadataProvider() == null ? 0 : this.getMetadataProvider().hashCode());
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        return hashCode;
    }

    public S3DataInput clone() {
        try {
            return (S3DataInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

