/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.Resource;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<Date> LASTREPORTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastReportedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> OWNINGACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwningAccountId").build();
    private static final MarshallingInfo<List> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Service").build();
    private static final ResourceMarshaller instance = new ResourceMarshaller();

    public static ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        if (resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resource.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)resource.getLastReportedAt(), LASTREPORTEDAT_BINDING);
            protocolMarshaller.marshall((Object)resource.getOwningAccountId(), OWNINGACCOUNTID_BINDING);
            protocolMarshaller.marshall(resource.getProperties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)resource.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)resource.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resource.getService(), SERVICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

