/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkmanager.model.NetworkResource;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class NetworkResourceMarshaller {
    private static final MarshallingInfo<String> REGISTEREDGATEWAYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredGatewayArn").build();
    private static final MarshallingInfo<String> CORENETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreNetworkId").build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegion").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<String> DEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Definition").build();
    private static final MarshallingInfo<Date> DEFINITIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefinitionTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<Map> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").build();
    private static final NetworkResourceMarshaller instance = new NetworkResourceMarshaller();

    public static NetworkResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkResource networkResource, ProtocolMarshaller protocolMarshaller) {
        if (networkResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkResource.getRegisteredGatewayArn(), REGISTEREDGATEWAYARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getCoreNetworkId(), CORENETWORKID_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getAwsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getDefinition(), DEFINITION_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getDefinitionTimestamp(), DEFINITIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(networkResource.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(networkResource.getMetadata(), METADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

