/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.transform.CoreNetworkSegmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CoreNetworkSegment
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> edgeLocations;
    private List<String> sharedSegments;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CoreNetworkSegment withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getEdgeLocations() {
        return this.edgeLocations;
    }

    public void setEdgeLocations(Collection<String> edgeLocations) {
        if (edgeLocations == null) {
            this.edgeLocations = null;
            return;
        }
        this.edgeLocations = new ArrayList<String>(edgeLocations);
    }

    public CoreNetworkSegment withEdgeLocations(String ... edgeLocations) {
        if (this.edgeLocations == null) {
            this.setEdgeLocations(new ArrayList<String>(edgeLocations.length));
        }
        for (String ele : edgeLocations) {
            this.edgeLocations.add(ele);
        }
        return this;
    }

    public CoreNetworkSegment withEdgeLocations(Collection<String> edgeLocations) {
        this.setEdgeLocations(edgeLocations);
        return this;
    }

    public List<String> getSharedSegments() {
        return this.sharedSegments;
    }

    public void setSharedSegments(Collection<String> sharedSegments) {
        if (sharedSegments == null) {
            this.sharedSegments = null;
            return;
        }
        this.sharedSegments = new ArrayList<String>(sharedSegments);
    }

    public CoreNetworkSegment withSharedSegments(String ... sharedSegments) {
        if (this.sharedSegments == null) {
            this.setSharedSegments(new ArrayList<String>(sharedSegments.length));
        }
        for (String ele : sharedSegments) {
            this.sharedSegments.add(ele);
        }
        return this;
    }

    public CoreNetworkSegment withSharedSegments(Collection<String> sharedSegments) {
        this.setSharedSegments(sharedSegments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getEdgeLocations() != null) {
            sb.append("EdgeLocations: ").append(this.getEdgeLocations()).append(",");
        }
        if (this.getSharedSegments() != null) {
            sb.append("SharedSegments: ").append(this.getSharedSegments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkSegment)) {
            return false;
        }
        CoreNetworkSegment other = (CoreNetworkSegment)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getEdgeLocations() == null ^ this.getEdgeLocations() == null) {
            return false;
        }
        if (other.getEdgeLocations() != null && !other.getEdgeLocations().equals(this.getEdgeLocations())) {
            return false;
        }
        if (other.getSharedSegments() == null ^ this.getSharedSegments() == null) {
            return false;
        }
        return other.getSharedSegments() == null || other.getSharedSegments().equals(this.getSharedSegments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getEdgeLocations() == null ? 0 : this.getEdgeLocations().hashCode());
        hashCode = 31 * hashCode + (this.getSharedSegments() == null ? 0 : this.getSharedSegments().hashCode());
        return hashCode;
    }

    public CoreNetworkSegment clone() {
        try {
            return (CoreNetworkSegment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoreNetworkSegmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

