/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartMLModelTransformJobRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     */
    private String dataProcessingJobId;
    /**
     * <p>
     * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     */
    private String mlModelTrainingJobId;
    /**
     * <p>
     * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     */
    private String trainingJobName;
    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     */
    private String modelTransformOutputS3Location;
    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     */
    private String sagemakerIamRoleArn;
    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     */
    private String neptuneIamRoleArn;
    /**
     * <p>
     * Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following fields, which must have values
     * compatible with the saved model parameters from the training job:
     * </p>
     */
    private CustomModelTransformParameters customModelTransformParameters;
    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
     * chosen based on memory requirements for processing the training data and model.
     * </p>
     */
    private String baseProcessingInstanceType;
    /**
     * <p>
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0,
     * Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     */
    private Integer baseProcessingInstanceVolumeSizeInGB;
    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     */
    private java.util.List<String> subnets;
    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     */
    private java.util.List<String> securityGroupIds;
    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     */
    private String volumeEncryptionKMSKey;
    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     */
    private String s3OutputEncryptionKMSKey;

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is an autogenerated UUID.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is an autogenerated UUID.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @param id
     *        A unique identifier for the new job. The default is an autogenerated UUID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param dataProcessingJobId
     *        The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code>
     *        and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public void setDataProcessingJobId(String dataProcessingJobId) {
        this.dataProcessingJobId = dataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public String getDataProcessingJobId() {
        return this.dataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param dataProcessingJobId
     *        The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code>
     *        and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withDataProcessingJobId(String dataProcessingJobId) {
        setDataProcessingJobId(dataProcessingJobId);
        return this;
    }

    /**
     * <p>
     * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param mlModelTrainingJobId
     *        The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and
     *        a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public void setMlModelTrainingJobId(String mlModelTrainingJobId) {
        this.mlModelTrainingJobId = mlModelTrainingJobId;
    }

    /**
     * <p>
     * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public String getMlModelTrainingJobId() {
        return this.mlModelTrainingJobId;
    }

    /**
     * <p>
     * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param mlModelTrainingJobId
     *        The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and
     *        a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withMlModelTrainingJobId(String mlModelTrainingJobId) {
        setMlModelTrainingJobId(mlModelTrainingJobId);
        return this;
    }

    /**
     * <p>
     * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param trainingJobName
     *        The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code>
     *        and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public void setTrainingJobName(String trainingJobName) {
        this.trainingJobName = trainingJobName;
    }

    /**
     * <p>
     * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */

    public String getTrainingJobName() {
        return this.trainingJobName;
    }

    /**
     * <p>
     * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @param trainingJobName
     *        The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code>
     *        and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withTrainingJobName(String trainingJobName) {
        setTrainingJobName(trainingJobName);
        return this;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @param modelTransformOutputS3Location
     *        The location in Amazon S3 where the model artifacts are to be stored.
     */

    public void setModelTransformOutputS3Location(String modelTransformOutputS3Location) {
        this.modelTransformOutputS3Location = modelTransformOutputS3Location;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @return The location in Amazon S3 where the model artifacts are to be stored.
     */

    public String getModelTransformOutputS3Location() {
        return this.modelTransformOutputS3Location;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @param modelTransformOutputS3Location
     *        The location in Amazon S3 where the model artifacts are to be stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withModelTransformOutputS3Location(String modelTransformOutputS3Location) {
        setModelTransformOutputS3Location(modelTransformOutputS3Location);
        return this;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *        an error will occur.
     */

    public void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        this.sagemakerIamRoleArn = sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */

    public String getSagemakerIamRoleArn() {
        return this.sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @param sagemakerIamRoleArn
     *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *        an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withSagemakerIamRoleArn(String sagemakerIamRoleArn) {
        setSagemakerIamRoleArn(sagemakerIamRoleArn);
        return this;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *        listed in your DB cluster parameter group or an error will occur.
     */

    public void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
        this.neptuneIamRoleArn = neptuneIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */

    public String getNeptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @param neptuneIamRoleArn
     *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *        listed in your DB cluster parameter group or an error will occur.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withNeptuneIamRoleArn(String neptuneIamRoleArn) {
        setNeptuneIamRoleArn(neptuneIamRoleArn);
        return this;
    }

    /**
     * <p>
     * Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following fields, which must have values
     * compatible with the saved model parameters from the training job:
     * </p>
     * 
     * @param customModelTransformParameters
     *        Configuration information for a model transform using a custom model. The
     *        <code>customModelTransformParameters</code> object contains the following fields, which must have values
     *        compatible with the saved model parameters from the training job:
     */

    public void setCustomModelTransformParameters(CustomModelTransformParameters customModelTransformParameters) {
        this.customModelTransformParameters = customModelTransformParameters;
    }

    /**
     * <p>
     * Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following fields, which must have values
     * compatible with the saved model parameters from the training job:
     * </p>
     * 
     * @return Configuration information for a model transform using a custom model. The
     *         <code>customModelTransformParameters</code> object contains the following fields, which must have values
     *         compatible with the saved model parameters from the training job:
     */

    public CustomModelTransformParameters getCustomModelTransformParameters() {
        return this.customModelTransformParameters;
    }

    /**
     * <p>
     * Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following fields, which must have values
     * compatible with the saved model parameters from the training job:
     * </p>
     * 
     * @param customModelTransformParameters
     *        Configuration information for a model transform using a custom model. The
     *        <code>customModelTransformParameters</code> object contains the following fields, which must have values
     *        compatible with the saved model parameters from the training job:
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withCustomModelTransformParameters(CustomModelTransformParameters customModelTransformParameters) {
        setCustomModelTransformParameters(customModelTransformParameters);
        return this;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
     * chosen based on memory requirements for processing the training data and model.
     * </p>
     * 
     * @param baseProcessingInstanceType
     *        The type of ML instance used in preparing and managing training of ML models. This is an ML compute
     *        instance chosen based on memory requirements for processing the training data and model.
     */

    public void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
        this.baseProcessingInstanceType = baseProcessingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
     * chosen based on memory requirements for processing the training data and model.
     * </p>
     * 
     * @return The type of ML instance used in preparing and managing training of ML models. This is an ML compute
     *         instance chosen based on memory requirements for processing the training data and model.
     */

    public String getBaseProcessingInstanceType() {
        return this.baseProcessingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
     * chosen based on memory requirements for processing the training data and model.
     * </p>
     * 
     * @param baseProcessingInstanceType
     *        The type of ML instance used in preparing and managing training of ML models. This is an ML compute
     *        instance chosen based on memory requirements for processing the training data and model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withBaseProcessingInstanceType(String baseProcessingInstanceType) {
        setBaseProcessingInstanceType(baseProcessingInstanceType);
        return this;
    }

    /**
     * <p>
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0,
     * Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @param baseProcessingInstanceVolumeSizeInGB
     *        The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the
     *        output model are stored on disk, so the volume size must be large enough to hold both data sets. If not
     *        specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data
     *        processing step.
     */

    public void setBaseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
        this.baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0,
     * Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @return The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the
     *         output model are stored on disk, so the volume size must be large enough to hold both data sets. If not
     *         specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data
     *         processing step.
     */

    public Integer getBaseProcessingInstanceVolumeSizeInGB() {
        return this.baseProcessingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0,
     * Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @param baseProcessingInstanceVolumeSizeInGB
     *        The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the
     *        output model are stored on disk, so the volume size must be large enough to hold both data sets. If not
     *        specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data
     *        processing step.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withBaseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
        setBaseProcessingInstanceVolumeSizeInGB(baseProcessingInstanceVolumeSizeInGB);
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public java.util.List<String> getSubnets() {
        return subnets;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     */

    public void setSubnets(java.util.Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }

        this.subnets = new java.util.ArrayList<String>(subnets);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubnets(java.util.Collection)} or {@link #withSubnets(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withSubnets(String... subnets) {
        if (this.subnets == null) {
            setSubnets(new java.util.ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * 
     * @param subnets
     *        The IDs of the subnets in the Neptune VPC. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withSubnets(java.util.Collection<String> subnets) {
        setSubnets(subnets);
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */

    public java.util.List<String> getSecurityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     */

    public void setSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }

        this.securityGroupIds = new java.util.ArrayList<String>(securityGroupIds);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSecurityGroupIds(java.util.Collection)} or {@link #withSecurityGroupIds(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withSecurityGroupIds(String... securityGroupIds) {
        if (this.securityGroupIds == null) {
            setSecurityGroupIds(new java.util.ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * 
     * @param securityGroupIds
     *        The VPC security group IDs. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        setSecurityGroupIds(securityGroupIds);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *        attached to the ML compute instances that run the training job. The default is None.
     */

    public void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *         attached to the ML compute instances that run the training job. The default is None.
     */

    public String getVolumeEncryptionKMSKey() {
        return this.volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @param volumeEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *        attached to the ML compute instances that run the training job. The default is None.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
        setVolumeEncryptionKMSKey(volumeEncryptionKMSKey);
        return this;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *        job. The default is none.
     */

    public void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *         job. The default is none.
     */

    public String getS3OutputEncryptionKMSKey() {
        return this.s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @param s3OutputEncryptionKMSKey
     *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *        job. The default is none.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartMLModelTransformJobRequest withS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
        setS3OutputEncryptionKMSKey(s3OutputEncryptionKMSKey);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getDataProcessingJobId() != null)
            sb.append("DataProcessingJobId: ").append(getDataProcessingJobId()).append(",");
        if (getMlModelTrainingJobId() != null)
            sb.append("MlModelTrainingJobId: ").append(getMlModelTrainingJobId()).append(",");
        if (getTrainingJobName() != null)
            sb.append("TrainingJobName: ").append(getTrainingJobName()).append(",");
        if (getModelTransformOutputS3Location() != null)
            sb.append("ModelTransformOutputS3Location: ").append(getModelTransformOutputS3Location()).append(",");
        if (getSagemakerIamRoleArn() != null)
            sb.append("SagemakerIamRoleArn: ").append(getSagemakerIamRoleArn()).append(",");
        if (getNeptuneIamRoleArn() != null)
            sb.append("NeptuneIamRoleArn: ").append(getNeptuneIamRoleArn()).append(",");
        if (getCustomModelTransformParameters() != null)
            sb.append("CustomModelTransformParameters: ").append(getCustomModelTransformParameters()).append(",");
        if (getBaseProcessingInstanceType() != null)
            sb.append("BaseProcessingInstanceType: ").append(getBaseProcessingInstanceType()).append(",");
        if (getBaseProcessingInstanceVolumeSizeInGB() != null)
            sb.append("BaseProcessingInstanceVolumeSizeInGB: ").append(getBaseProcessingInstanceVolumeSizeInGB()).append(",");
        if (getSubnets() != null)
            sb.append("Subnets: ").append(getSubnets()).append(",");
        if (getSecurityGroupIds() != null)
            sb.append("SecurityGroupIds: ").append(getSecurityGroupIds()).append(",");
        if (getVolumeEncryptionKMSKey() != null)
            sb.append("VolumeEncryptionKMSKey: ").append(getVolumeEncryptionKMSKey()).append(",");
        if (getS3OutputEncryptionKMSKey() != null)
            sb.append("S3OutputEncryptionKMSKey: ").append(getS3OutputEncryptionKMSKey());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartMLModelTransformJobRequest == false)
            return false;
        StartMLModelTransformJobRequest other = (StartMLModelTransformJobRequest) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getDataProcessingJobId() == null ^ this.getDataProcessingJobId() == null)
            return false;
        if (other.getDataProcessingJobId() != null && other.getDataProcessingJobId().equals(this.getDataProcessingJobId()) == false)
            return false;
        if (other.getMlModelTrainingJobId() == null ^ this.getMlModelTrainingJobId() == null)
            return false;
        if (other.getMlModelTrainingJobId() != null && other.getMlModelTrainingJobId().equals(this.getMlModelTrainingJobId()) == false)
            return false;
        if (other.getTrainingJobName() == null ^ this.getTrainingJobName() == null)
            return false;
        if (other.getTrainingJobName() != null && other.getTrainingJobName().equals(this.getTrainingJobName()) == false)
            return false;
        if (other.getModelTransformOutputS3Location() == null ^ this.getModelTransformOutputS3Location() == null)
            return false;
        if (other.getModelTransformOutputS3Location() != null
                && other.getModelTransformOutputS3Location().equals(this.getModelTransformOutputS3Location()) == false)
            return false;
        if (other.getSagemakerIamRoleArn() == null ^ this.getSagemakerIamRoleArn() == null)
            return false;
        if (other.getSagemakerIamRoleArn() != null && other.getSagemakerIamRoleArn().equals(this.getSagemakerIamRoleArn()) == false)
            return false;
        if (other.getNeptuneIamRoleArn() == null ^ this.getNeptuneIamRoleArn() == null)
            return false;
        if (other.getNeptuneIamRoleArn() != null && other.getNeptuneIamRoleArn().equals(this.getNeptuneIamRoleArn()) == false)
            return false;
        if (other.getCustomModelTransformParameters() == null ^ this.getCustomModelTransformParameters() == null)
            return false;
        if (other.getCustomModelTransformParameters() != null
                && other.getCustomModelTransformParameters().equals(this.getCustomModelTransformParameters()) == false)
            return false;
        if (other.getBaseProcessingInstanceType() == null ^ this.getBaseProcessingInstanceType() == null)
            return false;
        if (other.getBaseProcessingInstanceType() != null && other.getBaseProcessingInstanceType().equals(this.getBaseProcessingInstanceType()) == false)
            return false;
        if (other.getBaseProcessingInstanceVolumeSizeInGB() == null ^ this.getBaseProcessingInstanceVolumeSizeInGB() == null)
            return false;
        if (other.getBaseProcessingInstanceVolumeSizeInGB() != null
                && other.getBaseProcessingInstanceVolumeSizeInGB().equals(this.getBaseProcessingInstanceVolumeSizeInGB()) == false)
            return false;
        if (other.getSubnets() == null ^ this.getSubnets() == null)
            return false;
        if (other.getSubnets() != null && other.getSubnets().equals(this.getSubnets()) == false)
            return false;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null)
            return false;
        if (other.getSecurityGroupIds() != null && other.getSecurityGroupIds().equals(this.getSecurityGroupIds()) == false)
            return false;
        if (other.getVolumeEncryptionKMSKey() == null ^ this.getVolumeEncryptionKMSKey() == null)
            return false;
        if (other.getVolumeEncryptionKMSKey() != null && other.getVolumeEncryptionKMSKey().equals(this.getVolumeEncryptionKMSKey()) == false)
            return false;
        if (other.getS3OutputEncryptionKMSKey() == null ^ this.getS3OutputEncryptionKMSKey() == null)
            return false;
        if (other.getS3OutputEncryptionKMSKey() != null && other.getS3OutputEncryptionKMSKey().equals(this.getS3OutputEncryptionKMSKey()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getDataProcessingJobId() == null) ? 0 : getDataProcessingJobId().hashCode());
        hashCode = prime * hashCode + ((getMlModelTrainingJobId() == null) ? 0 : getMlModelTrainingJobId().hashCode());
        hashCode = prime * hashCode + ((getTrainingJobName() == null) ? 0 : getTrainingJobName().hashCode());
        hashCode = prime * hashCode + ((getModelTransformOutputS3Location() == null) ? 0 : getModelTransformOutputS3Location().hashCode());
        hashCode = prime * hashCode + ((getSagemakerIamRoleArn() == null) ? 0 : getSagemakerIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getNeptuneIamRoleArn() == null) ? 0 : getNeptuneIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getCustomModelTransformParameters() == null) ? 0 : getCustomModelTransformParameters().hashCode());
        hashCode = prime * hashCode + ((getBaseProcessingInstanceType() == null) ? 0 : getBaseProcessingInstanceType().hashCode());
        hashCode = prime * hashCode + ((getBaseProcessingInstanceVolumeSizeInGB() == null) ? 0 : getBaseProcessingInstanceVolumeSizeInGB().hashCode());
        hashCode = prime * hashCode + ((getSubnets() == null) ? 0 : getSubnets().hashCode());
        hashCode = prime * hashCode + ((getSecurityGroupIds() == null) ? 0 : getSecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getVolumeEncryptionKMSKey() == null) ? 0 : getVolumeEncryptionKMSKey().hashCode());
        hashCode = prime * hashCode + ((getS3OutputEncryptionKMSKey() == null) ? 0 : getS3OutputEncryptionKMSKey().hashCode());
        return hashCode;
    }

    @Override
    public StartMLModelTransformJobRequest clone() {
        return (StartMLModelTransformJobRequest) super.clone();
    }

}
