/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagevod.model.MssEncryption;
import com.amazonaws.services.mediapackagevod.model.MssManifest;
import com.amazonaws.services.mediapackagevod.model.transform.MssPackageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MssPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private MssEncryption encryption;
    private List<MssManifest> mssManifests;
    private Integer segmentDurationSeconds;

    public void setEncryption(MssEncryption encryption) {
        this.encryption = encryption;
    }

    public MssEncryption getEncryption() {
        return this.encryption;
    }

    public MssPackage withEncryption(MssEncryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public List<MssManifest> getMssManifests() {
        return this.mssManifests;
    }

    public void setMssManifests(Collection<MssManifest> mssManifests) {
        if (mssManifests == null) {
            this.mssManifests = null;
            return;
        }
        this.mssManifests = new ArrayList<MssManifest>(mssManifests);
    }

    public MssPackage withMssManifests(MssManifest ... mssManifests) {
        if (this.mssManifests == null) {
            this.setMssManifests(new ArrayList<MssManifest>(mssManifests.length));
        }
        for (MssManifest ele : mssManifests) {
            this.mssManifests.add(ele);
        }
        return this;
    }

    public MssPackage withMssManifests(Collection<MssManifest> mssManifests) {
        this.setMssManifests(mssManifests);
        return this;
    }

    public void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.segmentDurationSeconds = segmentDurationSeconds;
    }

    public Integer getSegmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public MssPackage withSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.setSegmentDurationSeconds(segmentDurationSeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getMssManifests() != null) {
            sb.append("MssManifests: ").append(this.getMssManifests()).append(",");
        }
        if (this.getSegmentDurationSeconds() != null) {
            sb.append("SegmentDurationSeconds: ").append(this.getSegmentDurationSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage)obj;
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getMssManifests() == null ^ this.getMssManifests() == null) {
            return false;
        }
        if (other.getMssManifests() != null && !other.getMssManifests().equals(this.getMssManifests())) {
            return false;
        }
        if (other.getSegmentDurationSeconds() == null ^ this.getSegmentDurationSeconds() == null) {
            return false;
        }
        return other.getSegmentDurationSeconds() == null || other.getSegmentDurationSeconds().equals(this.getSegmentDurationSeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getMssManifests() == null ? 0 : this.getMssManifests().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentDurationSeconds() == null ? 0 : this.getSegmentDurationSeconds().hashCode());
        return hashCode;
    }

    public MssPackage clone() {
        try {
            return (MssPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MssPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

