/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mainframemodernization.model.StorageConfiguration;

@SdkInternalApi
public class StorageConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> EFS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("efs").build();
    private static final MarshallingInfo<StructuredPojo> FSX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fsx").build();
    private static final StorageConfigurationMarshaller instance = new StorageConfigurationMarshaller();

    public static StorageConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageConfiguration storageConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (storageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageConfiguration.getEfs(), EFS_BINDING);
            protocolMarshaller.marshall((Object)storageConfiguration.getFsx(), FSX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

