/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lexmodelsv2.model.SessionSpecification;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SessionSpecificationMarshaller {
    private static final MarshallingInfo<String> BOTALIASID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botAliasId").build();
    private static final MarshallingInfo<String> BOTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botVersion").build();
    private static final MarshallingInfo<String> LOCALEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("localeId").build();
    private static final MarshallingInfo<String> CHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channel").build();
    private static final MarshallingInfo<String> SESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionId").build();
    private static final MarshallingInfo<Date> CONVERSATIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CONVERSATIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> CONVERSATIONDURATIONSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationDurationSeconds").build();
    private static final MarshallingInfo<String> CONVERSATIONENDSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("conversationEndState").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").build();
    private static final MarshallingInfo<Long> NUMBEROFTURNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfTurns").build();
    private static final MarshallingInfo<List> INVOKEDINTENTSAMPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("invokedIntentSamples").build();
    private static final MarshallingInfo<String> ORIGINATINGREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("originatingRequestId").build();
    private static final SessionSpecificationMarshaller instance = new SessionSpecificationMarshaller();

    public static SessionSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionSpecification sessionSpecification, ProtocolMarshaller protocolMarshaller) {
        if (sessionSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionSpecification.getBotAliasId(), BOTALIASID_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getBotVersion(), BOTVERSION_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getLocaleId(), LOCALEID_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getChannel(), CHANNEL_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getSessionId(), SESSIONID_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getConversationStartTime(), CONVERSATIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getConversationEndTime(), CONVERSATIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getConversationDurationSeconds(), CONVERSATIONDURATIONSECONDS_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getConversationEndState(), CONVERSATIONENDSTATE_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getMode(), MODE_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getNumberOfTurns(), NUMBEROFTURNS_BINDING);
            protocolMarshaller.marshall(sessionSpecification.getInvokedIntentSamples(), INVOKEDINTENTSAMPLES_BINDING);
            protocolMarshaller.marshall((Object)sessionSpecification.getOriginatingRequestId(), ORIGINATINGREQUESTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

