/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.ConfigurationType;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.ParallelismConfigurationMarshaller;
import java.io.Serializable;

public class ParallelismConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String configurationType;
    private Integer parallelism;
    private Integer parallelismPerKPU;
    private Boolean autoScalingEnabled;

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    public String getConfigurationType() {
        return this.configurationType;
    }

    public ParallelismConfiguration withConfigurationType(String configurationType) {
        this.setConfigurationType(configurationType);
        return this;
    }

    public ParallelismConfiguration withConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType.toString();
        return this;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public ParallelismConfiguration withParallelism(Integer parallelism) {
        this.setParallelism(parallelism);
        return this;
    }

    public void setParallelismPerKPU(Integer parallelismPerKPU) {
        this.parallelismPerKPU = parallelismPerKPU;
    }

    public Integer getParallelismPerKPU() {
        return this.parallelismPerKPU;
    }

    public ParallelismConfiguration withParallelismPerKPU(Integer parallelismPerKPU) {
        this.setParallelismPerKPU(parallelismPerKPU);
        return this;
    }

    public void setAutoScalingEnabled(Boolean autoScalingEnabled) {
        this.autoScalingEnabled = autoScalingEnabled;
    }

    public Boolean getAutoScalingEnabled() {
        return this.autoScalingEnabled;
    }

    public ParallelismConfiguration withAutoScalingEnabled(Boolean autoScalingEnabled) {
        this.setAutoScalingEnabled(autoScalingEnabled);
        return this;
    }

    public Boolean isAutoScalingEnabled() {
        return this.autoScalingEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurationType() != null) {
            sb.append("ConfigurationType: ").append(this.getConfigurationType()).append(",");
        }
        if (this.getParallelism() != null) {
            sb.append("Parallelism: ").append(this.getParallelism()).append(",");
        }
        if (this.getParallelismPerKPU() != null) {
            sb.append("ParallelismPerKPU: ").append(this.getParallelismPerKPU()).append(",");
        }
        if (this.getAutoScalingEnabled() != null) {
            sb.append("AutoScalingEnabled: ").append(this.getAutoScalingEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelismConfiguration)) {
            return false;
        }
        ParallelismConfiguration other = (ParallelismConfiguration)obj;
        if (other.getConfigurationType() == null ^ this.getConfigurationType() == null) {
            return false;
        }
        if (other.getConfigurationType() != null && !other.getConfigurationType().equals(this.getConfigurationType())) {
            return false;
        }
        if (other.getParallelism() == null ^ this.getParallelism() == null) {
            return false;
        }
        if (other.getParallelism() != null && !other.getParallelism().equals(this.getParallelism())) {
            return false;
        }
        if (other.getParallelismPerKPU() == null ^ this.getParallelismPerKPU() == null) {
            return false;
        }
        if (other.getParallelismPerKPU() != null && !other.getParallelismPerKPU().equals(this.getParallelismPerKPU())) {
            return false;
        }
        if (other.getAutoScalingEnabled() == null ^ this.getAutoScalingEnabled() == null) {
            return false;
        }
        return other.getAutoScalingEnabled() == null || other.getAutoScalingEnabled().equals(this.getAutoScalingEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurationType() == null ? 0 : this.getConfigurationType().hashCode());
        hashCode = 31 * hashCode + (this.getParallelism() == null ? 0 : this.getParallelism().hashCode());
        hashCode = 31 * hashCode + (this.getParallelismPerKPU() == null ? 0 : this.getParallelismPerKPU().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingEnabled() == null ? 0 : this.getAutoScalingEnabled().hashCode());
        return hashCode;
    }

    public ParallelismConfiguration clone() {
        try {
            return (ParallelismConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParallelismConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

