/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateBulkImportJobResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the job.
     * </p>
     */
    private String jobId;
    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     */
    private String jobName;
    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     */
    private String jobStatus;

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @param jobId
     *        The ID of the job.
     */

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */

    public String getJobId() {
        return this.jobId;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @param jobId
     *        The ID of the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBulkImportJobResult withJobId(String jobId) {
        setJobId(jobId);
        return this;
    }

    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     * 
     * @param jobName
     *        The unique name that helps identify the job request.
     */

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     * 
     * @return The unique name that helps identify the job request.
     */

    public String getJobName() {
        return this.jobName;
    }

    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     * 
     * @param jobName
     *        The unique name that helps identify the job request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBulkImportJobResult withJobName(String jobName) {
        setJobName(jobName);
        return this;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the bulk import job can be one of following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CANCELLED</code> – The bulk import job has been canceled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *        use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *        with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *        issues.
     *        </p>
     *        </li>
     * @see JobStatus
     */

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the bulk import job can be one of following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The bulk import job has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *         use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *         with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *         issues.
     *         </p>
     *         </li>
     * @see JobStatus
     */

    public String getJobStatus() {
        return this.jobStatus;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the bulk import job can be one of following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CANCELLED</code> – The bulk import job has been canceled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *        use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *        with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *        issues.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public CreateBulkImportJobResult withJobStatus(String jobStatus) {
        setJobStatus(jobStatus);
        return this;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the bulk import job can be one of following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CANCELLED</code> – The bulk import job has been canceled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *        use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *        with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *        issues.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public CreateBulkImportJobResult withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobId() != null)
            sb.append("JobId: ").append(getJobId()).append(",");
        if (getJobName() != null)
            sb.append("JobName: ").append(getJobName()).append(",");
        if (getJobStatus() != null)
            sb.append("JobStatus: ").append(getJobStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateBulkImportJobResult == false)
            return false;
        CreateBulkImportJobResult other = (CreateBulkImportJobResult) obj;
        if (other.getJobId() == null ^ this.getJobId() == null)
            return false;
        if (other.getJobId() != null && other.getJobId().equals(this.getJobId()) == false)
            return false;
        if (other.getJobName() == null ^ this.getJobName() == null)
            return false;
        if (other.getJobName() != null && other.getJobName().equals(this.getJobName()) == false)
            return false;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null)
            return false;
        if (other.getJobStatus() != null && other.getJobStatus().equals(this.getJobStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobId() == null) ? 0 : getJobId().hashCode());
        hashCode = prime * hashCode + ((getJobName() == null) ? 0 : getJobName().hashCode());
        hashCode = prime * hashCode + ((getJobStatus() == null) ? 0 : getJobStatus().hashCode());
        return hashCode;
    }

    @Override
    public CreateBulkImportJobResult clone() {
        try {
            return (CreateBulkImportJobResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
