/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.internetmonitor.model.Network;
import com.amazonaws.services.internetmonitor.model.TriangulationEventType;
import com.amazonaws.services.internetmonitor.model.transform.NetworkImpairmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkImpairment
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Network> networks;
    private List<Network> asPath;
    private String networkEventType;

    public List<Network> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<Network> networks) {
        if (networks == null) {
            this.networks = null;
            return;
        }
        this.networks = new ArrayList<Network>(networks);
    }

    public NetworkImpairment withNetworks(Network ... networks) {
        if (this.networks == null) {
            this.setNetworks(new ArrayList<Network>(networks.length));
        }
        for (Network ele : networks) {
            this.networks.add(ele);
        }
        return this;
    }

    public NetworkImpairment withNetworks(Collection<Network> networks) {
        this.setNetworks(networks);
        return this;
    }

    public List<Network> getAsPath() {
        return this.asPath;
    }

    public void setAsPath(Collection<Network> asPath) {
        if (asPath == null) {
            this.asPath = null;
            return;
        }
        this.asPath = new ArrayList<Network>(asPath);
    }

    public NetworkImpairment withAsPath(Network ... asPath) {
        if (this.asPath == null) {
            this.setAsPath(new ArrayList<Network>(asPath.length));
        }
        for (Network ele : asPath) {
            this.asPath.add(ele);
        }
        return this;
    }

    public NetworkImpairment withAsPath(Collection<Network> asPath) {
        this.setAsPath(asPath);
        return this;
    }

    public void setNetworkEventType(String networkEventType) {
        this.networkEventType = networkEventType;
    }

    public String getNetworkEventType() {
        return this.networkEventType;
    }

    public NetworkImpairment withNetworkEventType(String networkEventType) {
        this.setNetworkEventType(networkEventType);
        return this;
    }

    public NetworkImpairment withNetworkEventType(TriangulationEventType networkEventType) {
        this.networkEventType = networkEventType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworks() != null) {
            sb.append("Networks: ").append(this.getNetworks()).append(",");
        }
        if (this.getAsPath() != null) {
            sb.append("AsPath: ").append(this.getAsPath()).append(",");
        }
        if (this.getNetworkEventType() != null) {
            sb.append("NetworkEventType: ").append(this.getNetworkEventType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkImpairment)) {
            return false;
        }
        NetworkImpairment other = (NetworkImpairment)obj;
        if (other.getNetworks() == null ^ this.getNetworks() == null) {
            return false;
        }
        if (other.getNetworks() != null && !other.getNetworks().equals(this.getNetworks())) {
            return false;
        }
        if (other.getAsPath() == null ^ this.getAsPath() == null) {
            return false;
        }
        if (other.getAsPath() != null && !other.getAsPath().equals(this.getAsPath())) {
            return false;
        }
        if (other.getNetworkEventType() == null ^ this.getNetworkEventType() == null) {
            return false;
        }
        return other.getNetworkEventType() == null || other.getNetworkEventType().equals(this.getNetworkEventType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworks() == null ? 0 : this.getNetworks().hashCode());
        hashCode = 31 * hashCode + (this.getAsPath() == null ? 0 : this.getAsPath().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkEventType() == null ? 0 : this.getNetworkEventType().hashCode());
        return hashCode;
    }

    public NetworkImpairment clone() {
        try {
            return (NetworkImpairment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkImpairmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

