/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fis.model.TargetResourceType;
import java.util.Map;

@SdkInternalApi
public class TargetResourceTypeMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final TargetResourceTypeMarshaller instance = new TargetResourceTypeMarshaller();

    public static TargetResourceTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(TargetResourceType targetResourceType, ProtocolMarshaller protocolMarshaller) {
        if (targetResourceType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)targetResourceType.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)targetResourceType.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(targetResourceType.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

