/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.AutoScalingConfiguration;
import com.amazonaws.services.computeoptimizer.model.ContainerConfiguration;
import com.amazonaws.services.computeoptimizer.model.transform.ServiceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer memory;
    private Integer cpu;
    private List<ContainerConfiguration> containerConfigurations;
    private String autoScalingConfiguration;
    private String taskDefinitionArn;

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public ServiceConfiguration withMemory(Integer memory) {
        this.setMemory(memory);
        return this;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public ServiceConfiguration withCpu(Integer cpu) {
        this.setCpu(cpu);
        return this;
    }

    public List<ContainerConfiguration> getContainerConfigurations() {
        return this.containerConfigurations;
    }

    public void setContainerConfigurations(Collection<ContainerConfiguration> containerConfigurations) {
        if (containerConfigurations == null) {
            this.containerConfigurations = null;
            return;
        }
        this.containerConfigurations = new ArrayList<ContainerConfiguration>(containerConfigurations);
    }

    public ServiceConfiguration withContainerConfigurations(ContainerConfiguration ... containerConfigurations) {
        if (this.containerConfigurations == null) {
            this.setContainerConfigurations(new ArrayList<ContainerConfiguration>(containerConfigurations.length));
        }
        for (ContainerConfiguration ele : containerConfigurations) {
            this.containerConfigurations.add(ele);
        }
        return this;
    }

    public ServiceConfiguration withContainerConfigurations(Collection<ContainerConfiguration> containerConfigurations) {
        this.setContainerConfigurations(containerConfigurations);
        return this;
    }

    public void setAutoScalingConfiguration(String autoScalingConfiguration) {
        this.autoScalingConfiguration = autoScalingConfiguration;
    }

    public String getAutoScalingConfiguration() {
        return this.autoScalingConfiguration;
    }

    public ServiceConfiguration withAutoScalingConfiguration(String autoScalingConfiguration) {
        this.setAutoScalingConfiguration(autoScalingConfiguration);
        return this;
    }

    public ServiceConfiguration withAutoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
        this.autoScalingConfiguration = autoScalingConfiguration.toString();
        return this;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public ServiceConfiguration withTaskDefinitionArn(String taskDefinitionArn) {
        this.setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getContainerConfigurations() != null) {
            sb.append("ContainerConfigurations: ").append(this.getContainerConfigurations()).append(",");
        }
        if (this.getAutoScalingConfiguration() != null) {
            sb.append("AutoScalingConfiguration: ").append(this.getAutoScalingConfiguration()).append(",");
        }
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: ").append(this.getTaskDefinitionArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)obj;
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getContainerConfigurations() == null ^ this.getContainerConfigurations() == null) {
            return false;
        }
        if (other.getContainerConfigurations() != null && !other.getContainerConfigurations().equals(this.getContainerConfigurations())) {
            return false;
        }
        if (other.getAutoScalingConfiguration() == null ^ this.getAutoScalingConfiguration() == null) {
            return false;
        }
        if (other.getAutoScalingConfiguration() != null && !other.getAutoScalingConfiguration().equals(this.getAutoScalingConfiguration())) {
            return false;
        }
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        return other.getTaskDefinitionArn() == null || other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getContainerConfigurations() == null ? 0 : this.getContainerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingConfiguration() == null ? 0 : this.getAutoScalingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        return hashCode;
    }

    public ServiceConfiguration clone() {
        try {
            return (ServiceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

