/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.PreferredResourceName;
import com.amazonaws.services.computeoptimizer.model.transform.PreferredResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PreferredResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> includeList;
    private List<String> excludeList;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PreferredResource withName(String name) {
        this.setName(name);
        return this;
    }

    public PreferredResource withName(PreferredResourceName name) {
        this.name = name.toString();
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public void setIncludeList(Collection<String> includeList) {
        if (includeList == null) {
            this.includeList = null;
            return;
        }
        this.includeList = new ArrayList<String>(includeList);
    }

    public PreferredResource withIncludeList(String ... includeList) {
        if (this.includeList == null) {
            this.setIncludeList(new ArrayList<String>(includeList.length));
        }
        for (String ele : includeList) {
            this.includeList.add(ele);
        }
        return this;
    }

    public PreferredResource withIncludeList(Collection<String> includeList) {
        this.setIncludeList(includeList);
        return this;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(Collection<String> excludeList) {
        if (excludeList == null) {
            this.excludeList = null;
            return;
        }
        this.excludeList = new ArrayList<String>(excludeList);
    }

    public PreferredResource withExcludeList(String ... excludeList) {
        if (this.excludeList == null) {
            this.setExcludeList(new ArrayList<String>(excludeList.length));
        }
        for (String ele : excludeList) {
            this.excludeList.add(ele);
        }
        return this;
    }

    public PreferredResource withExcludeList(Collection<String> excludeList) {
        this.setExcludeList(excludeList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIncludeList() != null) {
            sb.append("IncludeList: ").append(this.getIncludeList()).append(",");
        }
        if (this.getExcludeList() != null) {
            sb.append("ExcludeList: ").append(this.getExcludeList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreferredResource)) {
            return false;
        }
        PreferredResource other = (PreferredResource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIncludeList() == null ^ this.getIncludeList() == null) {
            return false;
        }
        if (other.getIncludeList() != null && !other.getIncludeList().equals(this.getIncludeList())) {
            return false;
        }
        if (other.getExcludeList() == null ^ this.getExcludeList() == null) {
            return false;
        }
        return other.getExcludeList() == null || other.getExcludeList().equals(this.getExcludeList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeList() == null ? 0 : this.getIncludeList().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeList() == null ? 0 : this.getExcludeList().hashCode());
        return hashCode;
    }

    public PreferredResource clone() {
        try {
            return (PreferredResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PreferredResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

