/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codeconnections.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListConnections" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListConnectionsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     */
    private String providerTypeFilter;
    /**
     * <p>
     * Filters the list of connections to those associated with a specified host.
     * </p>
     */
    private String hostArnFilter;
    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the
     * next set of connections in the list.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * 
     * @param providerTypeFilter
     *        Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @see ProviderType
     */

    public void setProviderTypeFilter(String providerTypeFilter) {
        this.providerTypeFilter = providerTypeFilter;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * 
     * @return Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @see ProviderType
     */

    public String getProviderTypeFilter() {
        return this.providerTypeFilter;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * 
     * @param providerTypeFilter
     *        Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProviderType
     */

    public ListConnectionsRequest withProviderTypeFilter(String providerTypeFilter) {
        setProviderTypeFilter(providerTypeFilter);
        return this;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * 
     * @param providerTypeFilter
     *        Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProviderType
     */

    public ListConnectionsRequest withProviderTypeFilter(ProviderType providerTypeFilter) {
        this.providerTypeFilter = providerTypeFilter.toString();
        return this;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified host.
     * </p>
     * 
     * @param hostArnFilter
     *        Filters the list of connections to those associated with a specified host.
     */

    public void setHostArnFilter(String hostArnFilter) {
        this.hostArnFilter = hostArnFilter;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified host.
     * </p>
     * 
     * @return Filters the list of connections to those associated with a specified host.
     */

    public String getHostArnFilter() {
        return this.hostArnFilter;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified host.
     * </p>
     * 
     * @param hostArnFilter
     *        Filters the list of connections to those associated with a specified host.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListConnectionsRequest withHostArnFilter(String hostArnFilter) {
        setHostArnFilter(hostArnFilter);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *        call with the returned <code>nextToken</code> value.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>nextToken</code> value.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *        call with the returned <code>nextToken</code> value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListConnectionsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the
     * next set of connections in the list.
     * </p>
     * 
     * @param nextToken
     *        The token that was returned from the previous <code>ListConnections</code> call, which can be used to
     *        return the next set of connections in the list.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the
     * next set of connections in the list.
     * </p>
     * 
     * @return The token that was returned from the previous <code>ListConnections</code> call, which can be used to
     *         return the next set of connections in the list.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the
     * next set of connections in the list.
     * </p>
     * 
     * @param nextToken
     *        The token that was returned from the previous <code>ListConnections</code> call, which can be used to
     *        return the next set of connections in the list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListConnectionsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProviderTypeFilter() != null)
            sb.append("ProviderTypeFilter: ").append(getProviderTypeFilter()).append(",");
        if (getHostArnFilter() != null)
            sb.append("HostArnFilter: ").append(getHostArnFilter()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListConnectionsRequest == false)
            return false;
        ListConnectionsRequest other = (ListConnectionsRequest) obj;
        if (other.getProviderTypeFilter() == null ^ this.getProviderTypeFilter() == null)
            return false;
        if (other.getProviderTypeFilter() != null && other.getProviderTypeFilter().equals(this.getProviderTypeFilter()) == false)
            return false;
        if (other.getHostArnFilter() == null ^ this.getHostArnFilter() == null)
            return false;
        if (other.getHostArnFilter() != null && other.getHostArnFilter().equals(this.getHostArnFilter()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProviderTypeFilter() == null) ? 0 : getProviderTypeFilter().hashCode());
        hashCode = prime * hashCode + ((getHostArnFilter() == null) ? 0 : getHostArnFilter().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListConnectionsRequest clone() {
        return (ListConnectionsRequest) super.clone();
    }

}
