/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.ResourceDetail;
import com.amazonaws.services.cloudformation.model.WarningDetail;
import com.amazonaws.services.cloudformation.model.transform.WarningDetailStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ResourceDetailStaxUnmarshaller
implements Unmarshaller<ResourceDetail, StaxUnmarshallerContext> {
    private static ResourceDetailStaxUnmarshaller instance;

    public ResourceDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceDetail resourceDetail = new ResourceDetail();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceDetail;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    resourceDetail.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    resourceDetail.setLogicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceIdentifier/entry", targetDepth)) {
                    Map.Entry<String, String> entry = ResourceIdentifierMapEntryUnmarshaller.getInstance().unmarshall(context);
                    resourceDetail.addResourceIdentifierEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("ResourceStatus", targetDepth)) {
                    resourceDetail.setResourceStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatusReason", targetDepth)) {
                    resourceDetail.setResourceStatusReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Warnings", targetDepth)) {
                    resourceDetail.withWarnings(new ArrayList<WarningDetail>());
                    continue;
                }
                if (!context.testExpression("Warnings/member", targetDepth)) continue;
                resourceDetail.withWarnings(WarningDetailStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceDetail;
    }

    public static ResourceDetailStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceDetailStaxUnmarshaller();
        }
        return instance;
    }

    private static class ResourceIdentifierMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static ResourceIdentifierMapEntryUnmarshaller instance;

        private ResourceIdentifierMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static ResourceIdentifierMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new ResourceIdentifierMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

