/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.cleanrooms.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AnalysisRuleCustomMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AnalysisRuleCustomMarshaller {

    private static final MarshallingInfo<List> ALLOWEDANALYSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedAnalyses").build();
    private static final MarshallingInfo<List> ALLOWEDANALYSISPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedAnalysisProviders").build();
    private static final MarshallingInfo<String> ADDITIONALANALYSES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalAnalyses").build();
    private static final MarshallingInfo<List> DISALLOWEDOUTPUTCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disallowedOutputColumns").build();
    private static final MarshallingInfo<StructuredPojo> DIFFERENTIALPRIVACY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("differentialPrivacy").build();

    private static final AnalysisRuleCustomMarshaller instance = new AnalysisRuleCustomMarshaller();

    public static AnalysisRuleCustomMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AnalysisRuleCustom analysisRuleCustom, ProtocolMarshaller protocolMarshaller) {

        if (analysisRuleCustom == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(analysisRuleCustom.getAllowedAnalyses(), ALLOWEDANALYSES_BINDING);
            protocolMarshaller.marshall(analysisRuleCustom.getAllowedAnalysisProviders(), ALLOWEDANALYSISPROVIDERS_BINDING);
            protocolMarshaller.marshall(analysisRuleCustom.getAdditionalAnalyses(), ADDITIONALANALYSES_BINDING);
            protocolMarshaller.marshall(analysisRuleCustom.getDisallowedOutputColumns(), DISALLOWEDOUTPUTCOLUMNS_BINDING);
            protocolMarshaller.marshall(analysisRuleCustom.getDifferentialPrivacy(), DIFFERENTIALPRIVACY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
