/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.billingconductor.AWSBillingConductorAsync;
import com.amazonaws.services.billingconductor.AWSBillingConductorAsyncClientBuilder;
import com.amazonaws.services.billingconductor.AWSBillingConductorClient;
import com.amazonaws.services.billingconductor.model.AssociateAccountsRequest;
import com.amazonaws.services.billingconductor.model.AssociateAccountsResult;
import com.amazonaws.services.billingconductor.model.AssociatePricingRulesRequest;
import com.amazonaws.services.billingconductor.model.AssociatePricingRulesResult;
import com.amazonaws.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.CreateBillingGroupRequest;
import com.amazonaws.services.billingconductor.model.CreateBillingGroupResult;
import com.amazonaws.services.billingconductor.model.CreateCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.CreateCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.CreatePricingPlanRequest;
import com.amazonaws.services.billingconductor.model.CreatePricingPlanResult;
import com.amazonaws.services.billingconductor.model.CreatePricingRuleRequest;
import com.amazonaws.services.billingconductor.model.CreatePricingRuleResult;
import com.amazonaws.services.billingconductor.model.DeleteBillingGroupRequest;
import com.amazonaws.services.billingconductor.model.DeleteBillingGroupResult;
import com.amazonaws.services.billingconductor.model.DeleteCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.DeleteCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.DeletePricingPlanRequest;
import com.amazonaws.services.billingconductor.model.DeletePricingPlanResult;
import com.amazonaws.services.billingconductor.model.DeletePricingRuleRequest;
import com.amazonaws.services.billingconductor.model.DeletePricingRuleResult;
import com.amazonaws.services.billingconductor.model.DisassociateAccountsRequest;
import com.amazonaws.services.billingconductor.model.DisassociateAccountsResult;
import com.amazonaws.services.billingconductor.model.DisassociatePricingRulesRequest;
import com.amazonaws.services.billingconductor.model.DisassociatePricingRulesResult;
import com.amazonaws.services.billingconductor.model.GetBillingGroupCostReportRequest;
import com.amazonaws.services.billingconductor.model.GetBillingGroupCostReportResult;
import com.amazonaws.services.billingconductor.model.ListAccountAssociationsRequest;
import com.amazonaws.services.billingconductor.model.ListAccountAssociationsResult;
import com.amazonaws.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import com.amazonaws.services.billingconductor.model.ListBillingGroupCostReportsResult;
import com.amazonaws.services.billingconductor.model.ListBillingGroupsRequest;
import com.amazonaws.services.billingconductor.model.ListBillingGroupsResult;
import com.amazonaws.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import com.amazonaws.services.billingconductor.model.ListCustomLineItemVersionsResult;
import com.amazonaws.services.billingconductor.model.ListCustomLineItemsRequest;
import com.amazonaws.services.billingconductor.model.ListCustomLineItemsResult;
import com.amazonaws.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import com.amazonaws.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResult;
import com.amazonaws.services.billingconductor.model.ListPricingPlansRequest;
import com.amazonaws.services.billingconductor.model.ListPricingPlansResult;
import com.amazonaws.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import com.amazonaws.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResult;
import com.amazonaws.services.billingconductor.model.ListPricingRulesRequest;
import com.amazonaws.services.billingconductor.model.ListPricingRulesResult;
import com.amazonaws.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.ListTagsForResourceRequest;
import com.amazonaws.services.billingconductor.model.ListTagsForResourceResult;
import com.amazonaws.services.billingconductor.model.TagResourceRequest;
import com.amazonaws.services.billingconductor.model.TagResourceResult;
import com.amazonaws.services.billingconductor.model.UntagResourceRequest;
import com.amazonaws.services.billingconductor.model.UntagResourceResult;
import com.amazonaws.services.billingconductor.model.UpdateBillingGroupRequest;
import com.amazonaws.services.billingconductor.model.UpdateBillingGroupResult;
import com.amazonaws.services.billingconductor.model.UpdateCustomLineItemRequest;
import com.amazonaws.services.billingconductor.model.UpdateCustomLineItemResult;
import com.amazonaws.services.billingconductor.model.UpdatePricingPlanRequest;
import com.amazonaws.services.billingconductor.model.UpdatePricingPlanResult;
import com.amazonaws.services.billingconductor.model.UpdatePricingRuleRequest;
import com.amazonaws.services.billingconductor.model.UpdatePricingRuleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBillingConductorAsyncClient
extends AWSBillingConductorClient
implements AWSBillingConductorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBillingConductorAsyncClientBuilder asyncBuilder() {
        return AWSBillingConductorAsyncClientBuilder.standard();
    }

    AWSBillingConductorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBillingConductorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateAccountsResult> associateAccountsAsync(AssociateAccountsRequest request) {
        return this.associateAccountsAsync(request, null);
    }

    @Override
    public Future<AssociateAccountsResult> associateAccountsAsync(AssociateAccountsRequest request, final AsyncHandler<AssociateAccountsRequest, AssociateAccountsResult> asyncHandler) {
        final AssociateAccountsRequest finalRequest = (AssociateAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateAccountsResult>(){

            @Override
            public AssociateAccountsResult call() throws Exception {
                AssociateAccountsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeAssociateAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociatePricingRulesResult> associatePricingRulesAsync(AssociatePricingRulesRequest request) {
        return this.associatePricingRulesAsync(request, null);
    }

    @Override
    public Future<AssociatePricingRulesResult> associatePricingRulesAsync(AssociatePricingRulesRequest request, final AsyncHandler<AssociatePricingRulesRequest, AssociatePricingRulesResult> asyncHandler) {
        final AssociatePricingRulesRequest finalRequest = (AssociatePricingRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociatePricingRulesResult>(){

            @Override
            public AssociatePricingRulesResult call() throws Exception {
                AssociatePricingRulesResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeAssociatePricingRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchAssociateResourcesToCustomLineItemResult> batchAssociateResourcesToCustomLineItemAsync(BatchAssociateResourcesToCustomLineItemRequest request) {
        return this.batchAssociateResourcesToCustomLineItemAsync(request, null);
    }

    @Override
    public Future<BatchAssociateResourcesToCustomLineItemResult> batchAssociateResourcesToCustomLineItemAsync(BatchAssociateResourcesToCustomLineItemRequest request, final AsyncHandler<BatchAssociateResourcesToCustomLineItemRequest, BatchAssociateResourcesToCustomLineItemResult> asyncHandler) {
        final BatchAssociateResourcesToCustomLineItemRequest finalRequest = (BatchAssociateResourcesToCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchAssociateResourcesToCustomLineItemResult>(){

            @Override
            public BatchAssociateResourcesToCustomLineItemResult call() throws Exception {
                BatchAssociateResourcesToCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeBatchAssociateResourcesToCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDisassociateResourcesFromCustomLineItemResult> batchDisassociateResourcesFromCustomLineItemAsync(BatchDisassociateResourcesFromCustomLineItemRequest request) {
        return this.batchDisassociateResourcesFromCustomLineItemAsync(request, null);
    }

    @Override
    public Future<BatchDisassociateResourcesFromCustomLineItemResult> batchDisassociateResourcesFromCustomLineItemAsync(BatchDisassociateResourcesFromCustomLineItemRequest request, final AsyncHandler<BatchDisassociateResourcesFromCustomLineItemRequest, BatchDisassociateResourcesFromCustomLineItemResult> asyncHandler) {
        final BatchDisassociateResourcesFromCustomLineItemRequest finalRequest = (BatchDisassociateResourcesFromCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDisassociateResourcesFromCustomLineItemResult>(){

            @Override
            public BatchDisassociateResourcesFromCustomLineItemResult call() throws Exception {
                BatchDisassociateResourcesFromCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeBatchDisassociateResourcesFromCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBillingGroupResult> createBillingGroupAsync(CreateBillingGroupRequest request) {
        return this.createBillingGroupAsync(request, null);
    }

    @Override
    public Future<CreateBillingGroupResult> createBillingGroupAsync(CreateBillingGroupRequest request, final AsyncHandler<CreateBillingGroupRequest, CreateBillingGroupResult> asyncHandler) {
        final CreateBillingGroupRequest finalRequest = (CreateBillingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBillingGroupResult>(){

            @Override
            public CreateBillingGroupResult call() throws Exception {
                CreateBillingGroupResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeCreateBillingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomLineItemResult> createCustomLineItemAsync(CreateCustomLineItemRequest request) {
        return this.createCustomLineItemAsync(request, null);
    }

    @Override
    public Future<CreateCustomLineItemResult> createCustomLineItemAsync(CreateCustomLineItemRequest request, final AsyncHandler<CreateCustomLineItemRequest, CreateCustomLineItemResult> asyncHandler) {
        final CreateCustomLineItemRequest finalRequest = (CreateCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCustomLineItemResult>(){

            @Override
            public CreateCustomLineItemResult call() throws Exception {
                CreateCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeCreateCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePricingPlanResult> createPricingPlanAsync(CreatePricingPlanRequest request) {
        return this.createPricingPlanAsync(request, null);
    }

    @Override
    public Future<CreatePricingPlanResult> createPricingPlanAsync(CreatePricingPlanRequest request, final AsyncHandler<CreatePricingPlanRequest, CreatePricingPlanResult> asyncHandler) {
        final CreatePricingPlanRequest finalRequest = (CreatePricingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePricingPlanResult>(){

            @Override
            public CreatePricingPlanResult call() throws Exception {
                CreatePricingPlanResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeCreatePricingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePricingRuleResult> createPricingRuleAsync(CreatePricingRuleRequest request) {
        return this.createPricingRuleAsync(request, null);
    }

    @Override
    public Future<CreatePricingRuleResult> createPricingRuleAsync(CreatePricingRuleRequest request, final AsyncHandler<CreatePricingRuleRequest, CreatePricingRuleResult> asyncHandler) {
        final CreatePricingRuleRequest finalRequest = (CreatePricingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePricingRuleResult>(){

            @Override
            public CreatePricingRuleResult call() throws Exception {
                CreatePricingRuleResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeCreatePricingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBillingGroupResult> deleteBillingGroupAsync(DeleteBillingGroupRequest request) {
        return this.deleteBillingGroupAsync(request, null);
    }

    @Override
    public Future<DeleteBillingGroupResult> deleteBillingGroupAsync(DeleteBillingGroupRequest request, final AsyncHandler<DeleteBillingGroupRequest, DeleteBillingGroupResult> asyncHandler) {
        final DeleteBillingGroupRequest finalRequest = (DeleteBillingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBillingGroupResult>(){

            @Override
            public DeleteBillingGroupResult call() throws Exception {
                DeleteBillingGroupResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDeleteBillingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomLineItemResult> deleteCustomLineItemAsync(DeleteCustomLineItemRequest request) {
        return this.deleteCustomLineItemAsync(request, null);
    }

    @Override
    public Future<DeleteCustomLineItemResult> deleteCustomLineItemAsync(DeleteCustomLineItemRequest request, final AsyncHandler<DeleteCustomLineItemRequest, DeleteCustomLineItemResult> asyncHandler) {
        final DeleteCustomLineItemRequest finalRequest = (DeleteCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomLineItemResult>(){

            @Override
            public DeleteCustomLineItemResult call() throws Exception {
                DeleteCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDeleteCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePricingPlanResult> deletePricingPlanAsync(DeletePricingPlanRequest request) {
        return this.deletePricingPlanAsync(request, null);
    }

    @Override
    public Future<DeletePricingPlanResult> deletePricingPlanAsync(DeletePricingPlanRequest request, final AsyncHandler<DeletePricingPlanRequest, DeletePricingPlanResult> asyncHandler) {
        final DeletePricingPlanRequest finalRequest = (DeletePricingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePricingPlanResult>(){

            @Override
            public DeletePricingPlanResult call() throws Exception {
                DeletePricingPlanResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDeletePricingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePricingRuleResult> deletePricingRuleAsync(DeletePricingRuleRequest request) {
        return this.deletePricingRuleAsync(request, null);
    }

    @Override
    public Future<DeletePricingRuleResult> deletePricingRuleAsync(DeletePricingRuleRequest request, final AsyncHandler<DeletePricingRuleRequest, DeletePricingRuleResult> asyncHandler) {
        final DeletePricingRuleRequest finalRequest = (DeletePricingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePricingRuleResult>(){

            @Override
            public DeletePricingRuleResult call() throws Exception {
                DeletePricingRuleResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDeletePricingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateAccountsResult> disassociateAccountsAsync(DisassociateAccountsRequest request) {
        return this.disassociateAccountsAsync(request, null);
    }

    @Override
    public Future<DisassociateAccountsResult> disassociateAccountsAsync(DisassociateAccountsRequest request, final AsyncHandler<DisassociateAccountsRequest, DisassociateAccountsResult> asyncHandler) {
        final DisassociateAccountsRequest finalRequest = (DisassociateAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateAccountsResult>(){

            @Override
            public DisassociateAccountsResult call() throws Exception {
                DisassociateAccountsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDisassociateAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociatePricingRulesResult> disassociatePricingRulesAsync(DisassociatePricingRulesRequest request) {
        return this.disassociatePricingRulesAsync(request, null);
    }

    @Override
    public Future<DisassociatePricingRulesResult> disassociatePricingRulesAsync(DisassociatePricingRulesRequest request, final AsyncHandler<DisassociatePricingRulesRequest, DisassociatePricingRulesResult> asyncHandler) {
        final DisassociatePricingRulesRequest finalRequest = (DisassociatePricingRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociatePricingRulesResult>(){

            @Override
            public DisassociatePricingRulesResult call() throws Exception {
                DisassociatePricingRulesResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeDisassociatePricingRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBillingGroupCostReportResult> getBillingGroupCostReportAsync(GetBillingGroupCostReportRequest request) {
        return this.getBillingGroupCostReportAsync(request, null);
    }

    @Override
    public Future<GetBillingGroupCostReportResult> getBillingGroupCostReportAsync(GetBillingGroupCostReportRequest request, final AsyncHandler<GetBillingGroupCostReportRequest, GetBillingGroupCostReportResult> asyncHandler) {
        final GetBillingGroupCostReportRequest finalRequest = (GetBillingGroupCostReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBillingGroupCostReportResult>(){

            @Override
            public GetBillingGroupCostReportResult call() throws Exception {
                GetBillingGroupCostReportResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeGetBillingGroupCostReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountAssociationsResult> listAccountAssociationsAsync(ListAccountAssociationsRequest request) {
        return this.listAccountAssociationsAsync(request, null);
    }

    @Override
    public Future<ListAccountAssociationsResult> listAccountAssociationsAsync(ListAccountAssociationsRequest request, final AsyncHandler<ListAccountAssociationsRequest, ListAccountAssociationsResult> asyncHandler) {
        final ListAccountAssociationsRequest finalRequest = (ListAccountAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountAssociationsResult>(){

            @Override
            public ListAccountAssociationsResult call() throws Exception {
                ListAccountAssociationsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListAccountAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBillingGroupCostReportsResult> listBillingGroupCostReportsAsync(ListBillingGroupCostReportsRequest request) {
        return this.listBillingGroupCostReportsAsync(request, null);
    }

    @Override
    public Future<ListBillingGroupCostReportsResult> listBillingGroupCostReportsAsync(ListBillingGroupCostReportsRequest request, final AsyncHandler<ListBillingGroupCostReportsRequest, ListBillingGroupCostReportsResult> asyncHandler) {
        final ListBillingGroupCostReportsRequest finalRequest = (ListBillingGroupCostReportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBillingGroupCostReportsResult>(){

            @Override
            public ListBillingGroupCostReportsResult call() throws Exception {
                ListBillingGroupCostReportsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListBillingGroupCostReports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBillingGroupsResult> listBillingGroupsAsync(ListBillingGroupsRequest request) {
        return this.listBillingGroupsAsync(request, null);
    }

    @Override
    public Future<ListBillingGroupsResult> listBillingGroupsAsync(ListBillingGroupsRequest request, final AsyncHandler<ListBillingGroupsRequest, ListBillingGroupsResult> asyncHandler) {
        final ListBillingGroupsRequest finalRequest = (ListBillingGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBillingGroupsResult>(){

            @Override
            public ListBillingGroupsResult call() throws Exception {
                ListBillingGroupsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListBillingGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCustomLineItemVersionsResult> listCustomLineItemVersionsAsync(ListCustomLineItemVersionsRequest request) {
        return this.listCustomLineItemVersionsAsync(request, null);
    }

    @Override
    public Future<ListCustomLineItemVersionsResult> listCustomLineItemVersionsAsync(ListCustomLineItemVersionsRequest request, final AsyncHandler<ListCustomLineItemVersionsRequest, ListCustomLineItemVersionsResult> asyncHandler) {
        final ListCustomLineItemVersionsRequest finalRequest = (ListCustomLineItemVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCustomLineItemVersionsResult>(){

            @Override
            public ListCustomLineItemVersionsResult call() throws Exception {
                ListCustomLineItemVersionsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListCustomLineItemVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCustomLineItemsResult> listCustomLineItemsAsync(ListCustomLineItemsRequest request) {
        return this.listCustomLineItemsAsync(request, null);
    }

    @Override
    public Future<ListCustomLineItemsResult> listCustomLineItemsAsync(ListCustomLineItemsRequest request, final AsyncHandler<ListCustomLineItemsRequest, ListCustomLineItemsResult> asyncHandler) {
        final ListCustomLineItemsRequest finalRequest = (ListCustomLineItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCustomLineItemsResult>(){

            @Override
            public ListCustomLineItemsResult call() throws Exception {
                ListCustomLineItemsResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListCustomLineItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPricingPlansResult> listPricingPlansAsync(ListPricingPlansRequest request) {
        return this.listPricingPlansAsync(request, null);
    }

    @Override
    public Future<ListPricingPlansResult> listPricingPlansAsync(ListPricingPlansRequest request, final AsyncHandler<ListPricingPlansRequest, ListPricingPlansResult> asyncHandler) {
        final ListPricingPlansRequest finalRequest = (ListPricingPlansRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPricingPlansResult>(){

            @Override
            public ListPricingPlansResult call() throws Exception {
                ListPricingPlansResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListPricingPlans(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPricingPlansAssociatedWithPricingRuleResult> listPricingPlansAssociatedWithPricingRuleAsync(ListPricingPlansAssociatedWithPricingRuleRequest request) {
        return this.listPricingPlansAssociatedWithPricingRuleAsync(request, null);
    }

    @Override
    public Future<ListPricingPlansAssociatedWithPricingRuleResult> listPricingPlansAssociatedWithPricingRuleAsync(ListPricingPlansAssociatedWithPricingRuleRequest request, final AsyncHandler<ListPricingPlansAssociatedWithPricingRuleRequest, ListPricingPlansAssociatedWithPricingRuleResult> asyncHandler) {
        final ListPricingPlansAssociatedWithPricingRuleRequest finalRequest = (ListPricingPlansAssociatedWithPricingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPricingPlansAssociatedWithPricingRuleResult>(){

            @Override
            public ListPricingPlansAssociatedWithPricingRuleResult call() throws Exception {
                ListPricingPlansAssociatedWithPricingRuleResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListPricingPlansAssociatedWithPricingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPricingRulesResult> listPricingRulesAsync(ListPricingRulesRequest request) {
        return this.listPricingRulesAsync(request, null);
    }

    @Override
    public Future<ListPricingRulesResult> listPricingRulesAsync(ListPricingRulesRequest request, final AsyncHandler<ListPricingRulesRequest, ListPricingRulesResult> asyncHandler) {
        final ListPricingRulesRequest finalRequest = (ListPricingRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPricingRulesResult>(){

            @Override
            public ListPricingRulesResult call() throws Exception {
                ListPricingRulesResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListPricingRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPricingRulesAssociatedToPricingPlanResult> listPricingRulesAssociatedToPricingPlanAsync(ListPricingRulesAssociatedToPricingPlanRequest request) {
        return this.listPricingRulesAssociatedToPricingPlanAsync(request, null);
    }

    @Override
    public Future<ListPricingRulesAssociatedToPricingPlanResult> listPricingRulesAssociatedToPricingPlanAsync(ListPricingRulesAssociatedToPricingPlanRequest request, final AsyncHandler<ListPricingRulesAssociatedToPricingPlanRequest, ListPricingRulesAssociatedToPricingPlanResult> asyncHandler) {
        final ListPricingRulesAssociatedToPricingPlanRequest finalRequest = (ListPricingRulesAssociatedToPricingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPricingRulesAssociatedToPricingPlanResult>(){

            @Override
            public ListPricingRulesAssociatedToPricingPlanResult call() throws Exception {
                ListPricingRulesAssociatedToPricingPlanResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListPricingRulesAssociatedToPricingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesAssociatedToCustomLineItemResult> listResourcesAssociatedToCustomLineItemAsync(ListResourcesAssociatedToCustomLineItemRequest request) {
        return this.listResourcesAssociatedToCustomLineItemAsync(request, null);
    }

    @Override
    public Future<ListResourcesAssociatedToCustomLineItemResult> listResourcesAssociatedToCustomLineItemAsync(ListResourcesAssociatedToCustomLineItemRequest request, final AsyncHandler<ListResourcesAssociatedToCustomLineItemRequest, ListResourcesAssociatedToCustomLineItemResult> asyncHandler) {
        final ListResourcesAssociatedToCustomLineItemRequest finalRequest = (ListResourcesAssociatedToCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesAssociatedToCustomLineItemResult>(){

            @Override
            public ListResourcesAssociatedToCustomLineItemResult call() throws Exception {
                ListResourcesAssociatedToCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListResourcesAssociatedToCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBillingGroupResult> updateBillingGroupAsync(UpdateBillingGroupRequest request) {
        return this.updateBillingGroupAsync(request, null);
    }

    @Override
    public Future<UpdateBillingGroupResult> updateBillingGroupAsync(UpdateBillingGroupRequest request, final AsyncHandler<UpdateBillingGroupRequest, UpdateBillingGroupResult> asyncHandler) {
        final UpdateBillingGroupRequest finalRequest = (UpdateBillingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBillingGroupResult>(){

            @Override
            public UpdateBillingGroupResult call() throws Exception {
                UpdateBillingGroupResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeUpdateBillingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCustomLineItemResult> updateCustomLineItemAsync(UpdateCustomLineItemRequest request) {
        return this.updateCustomLineItemAsync(request, null);
    }

    @Override
    public Future<UpdateCustomLineItemResult> updateCustomLineItemAsync(UpdateCustomLineItemRequest request, final AsyncHandler<UpdateCustomLineItemRequest, UpdateCustomLineItemResult> asyncHandler) {
        final UpdateCustomLineItemRequest finalRequest = (UpdateCustomLineItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCustomLineItemResult>(){

            @Override
            public UpdateCustomLineItemResult call() throws Exception {
                UpdateCustomLineItemResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeUpdateCustomLineItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePricingPlanResult> updatePricingPlanAsync(UpdatePricingPlanRequest request) {
        return this.updatePricingPlanAsync(request, null);
    }

    @Override
    public Future<UpdatePricingPlanResult> updatePricingPlanAsync(UpdatePricingPlanRequest request, final AsyncHandler<UpdatePricingPlanRequest, UpdatePricingPlanResult> asyncHandler) {
        final UpdatePricingPlanRequest finalRequest = (UpdatePricingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePricingPlanResult>(){

            @Override
            public UpdatePricingPlanResult call() throws Exception {
                UpdatePricingPlanResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeUpdatePricingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePricingRuleResult> updatePricingRuleAsync(UpdatePricingRuleRequest request) {
        return this.updatePricingRuleAsync(request, null);
    }

    @Override
    public Future<UpdatePricingRuleResult> updatePricingRuleAsync(UpdatePricingRuleRequest request, final AsyncHandler<UpdatePricingRuleRequest, UpdatePricingRuleResult> asyncHandler) {
        final UpdatePricingRuleRequest finalRequest = (UpdatePricingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePricingRuleResult>(){

            @Override
            public UpdatePricingRuleResult call() throws Exception {
                UpdatePricingRuleResult result = null;
                try {
                    result = AWSBillingConductorAsyncClient.this.executeUpdatePricingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

